<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Trait;

use Joomla\CMS\Factory;

trait BookingQueryTrait
{
    protected function getBookingQuery(string $select = '')
    {
        $db = Factory::getDbo();
        if (empty($select)) {
            $select = 'b.*, p.title, p.product_id AS item_id, p.image';
        }

        return $db->getQuery(true)
            ->select($select)
            ->from('#__gridbox_store_bookings AS b')
            ->leftJoin('#__gridbox_store_order_products AS p ON p.id = b.product_id')
            ->leftJoin('#__gridbox_store_orders AS o ON o.id = b.order_id')
            ->where('o.published = 1');
    }
}