<?php
/**
 * @package   Gridbox
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */


namespace Balbooa\Component\Gridbox\Administrator\Trait;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;

trait BulkActionsControllerTrait
{
    public function bulkAccess(): void
    {
        $this->executeBulkAction('bulkAccess');
    }

    public function bulkLanguage(): void
    {
        $this->executeBulkAction('bulkLanguage');
    }

    public function bulkTheme(): void
    {
        $this->executeBulkAction('bulkTheme');
    }

    public function bulkCategories(): void
    {
        $this->executeBulkAction('bulkCategories');
    }

    public function bulkAuthor(): void
    {
        $this->executeBulkAction('bulkAuthor');
    }

    public function bulkTags(): void
    {
        $this->executeBulkAction('bulkTags');
    }

    public function executeBulkAction(string $action): void
    {
        GridboxHelper::checkUserEditLevel();
        $cid = $this->input->get('cid', [], 'array');
        $value = $this->input->get('bulk-value', '', 'string');
        $model = $this->getModel();
        $model->{$action}($cid, $value);
        GridboxHelper::ajaxReload('ACTION_COMPLETED');
    }
}