<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Apps;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\View\BaseView;
use Joomla\CMS\Factory;

class HtmlView extends BaseView
{
    protected $items;
    protected $blog;
    protected $pagination;
    protected $state;
    protected $themes;
    protected $categories;
    protected $category;
    protected $access = [];
    protected $languages = [];
    protected $apps;
    protected $authors;
    protected $fields;
    protected $tagsFolders;
    
    public function display($tpl = null) 
    {
        $input = Factory::getApplication()->input;
        $layout = $input->get('layout', '', 'string');
        $id = $input->get('id', 0, 'int');
        if ($layout == 'modal') {
            $this->setLayout('modal');
            $this->items = $this->get('Items');
            $this->state = $this->get('State');
        } else {
            $this->apps = GridboxHelper::getApps();
            foreach ($this->apps as $app) {
                if ($app->id == $id) {
                    $this->blog = $app;
                    break;
                }
            }
            $this->tagsFolders = $this->get('TagsFolders');
            $this->category = $input->get('category', 0, 'int');
            $this->categories = $this->get('Categories');
            $this->categoryList = GridboxHelper::getAppCategories($id);
            $this->items = $this->get('Items');
            $this->authors = $this->get('Authors');
            foreach ($this->items as $item) {
                $item->app_type = $this->blog->type;
            }
            $this->pagination = $this->get('Pagination');
            $this->state = $this->get('State');
            $this->themes = $this->get('Themes');
            $this->fields = $this->get('PageFields');
            $this->access = GridboxHelper::getAccess();
            $this->languages = GridboxHelper::getLanguages();
        }
        
        parent::display($tpl);
    }

    public function drawCategoryList($items)
    {
        $str = '<ul>';
        $catUrl = 'index.php?option=com_gridbox&view=apps&id='.$this->blog->id.'&category=';
        $input = Factory::getApplication()->input;
        foreach ($items as $item) {
            $str .= '<li class="ba-category '.$item->active;
            $cookie = $input->cookie->exists('blog'.$this->blog->id.'id'.$item->id);
            if ($cookie) {
                $str .= ' visible-branch';
            }
            if (!$item->published) {
                $str .= ' ba-unpublish';
            }
            $str .= '" data-id="'.$item->id;
            $str .= '"><a href="'.$catUrl.$item->id.'">';
            $str .= '<label><i class="zmdi zmdi-folder"></i></label><span>'.$item->title.'</span>';
            $str .= '<input type="hidden" value="'.htmlspecialchars(json_encode($item), ENT_QUOTES).'"></a>';
            if (count($item->child) > 0) {
                $str .= '<i class="zmdi zmdi-chevron-right ba-icon-md"></i>';
                $str .= $this->drawCategoryList($item->child);
            }
            $str .= '<span>';
            $str .= '<i class="zmdi zmdi-apps sorting-handle ba-icon-md"></i>';
            $str .= '</span>';
            $str .= '</li>';
        }
        $str .= '</ul>';

        return $str;
    }
    
    protected function addToolBar(): void
    {
        $input = Factory::getApplication()->input;
        $layout = $input->get('layout', '', 'string');
        if ($layout == 'modal') {
            return;
        }
        if ($this->user->authorise('core.duplicate', 'com_gridbox')) {
            $this->toolbar->standardButton('copy', 'JTOOLBAR_DUPLICATE', 'apps.duplicate')
                ->listCheck(true);
        }
        if ($this->user->authorise('core.edit.state', 'com_gridbox')) {
            $this->toolbar->publish('apps.publish')->listCheck(true);
            $this->toolbar->unpublish('apps.unpublish')->listCheck(true);
        }

        if ($this->user->authorise('core.delete', 'com_gridbox')) {
            $this->toolbar->standardButton('trash', 'JTOOLBAR_TRASH', 'apps.addTrash')
                ->listCheck(true);
        }

        $childBar = $this->createChildToolbar();
        $childBar->standardButton('download', 'EXPORT', 'apps.export')
            ->listCheck(true);
        if ($this->blog->type == 'products' && $this->user->authorise('core.csv', 'com_gridbox')) {
            $childBar->standardButton('download', 'IMPORT_EXPORT_CSV', 'apps.exportcsv')
                ->listCheck(true);
        }
        if ($this->user->authorise('core.edit', 'com_gridbox')) {
            $childBar->standardButton('chevron-right', 'MOVE_TO', 'apps.moveTo')
                ->listCheck(true);
            $childBar->standardButton('folder', 'CATEGORY', 'pages.bulkCategories')
                ->listCheck(true);
            $childBar->standardButton('tag', 'TAGS', 'pages.bulkTags')
                ->listCheck(true);
            $childBar->standardButton('brush', 'THEME', 'pages.bulkTheme')
                ->listCheck(true);
            $childBar->standardButton('lock', 'JFIELD_ACCESS_LABEL', 'pages.bulkAccess')
                ->listCheck(true);
            $childBar->standardButton('cloud', 'JFIELD_LANGUAGE_LABEL', 'pages.bulkLanguage')
                ->listCheck(true);
            $childBar->standardButton('user', 'AUTHOR', 'pages.bulkAuthor')
                ->listCheck(true);
        }
    }
}