<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Appslist;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Uri\Uri;

class HtmlView extends BaseView
{
    protected $items;
    protected $state;
    protected $about;
    protected $apps;
    protected $system;

    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->system = $this->get('SystemApps');
        $this->apps = GridboxHelper::getApps();
        $this->state = $this->get('State');
        $this->about = GridboxHelper::aboutUs();
        $doc = Factory::getDocument();
        $doc->addStyleSheet('components/com_gridbox/assets/css/ba-admin.css?'.$this->about->version);
        $doc->addScript(Uri::root().'media/vendor/jquery/js/jquery.min.js');
                
        parent::display($tpl);
    }

    public function createAppObject($type, $icon, $title, $system = false)
    {
        return (object) [
            'type' => $type,
            'icon' => 'zmdi zmdi-'.$icon,
            'title' => $title,
            'system' => $system
        ];
    }

    public function getAppsList()
    {
        return [
            $this->createAppObject('single', 'file', Text::_('PAGES')),
            $this->createAppObject('blog', 'format-color-text', Text::_('BLOG')),
            $this->createAppObject('products', 'shopping-cart', Text::_('STORE')),
            $this->createAppObject('booking', 'calendar-check', Text::_('BOOKING')),
            $this->createAppObject('comments', 'comment-more', Text::_('COMMENTS'), true),
            $this->createAppObject('reviews', 'ticket-star', Text::_('REVIEWS'), true),
            $this->createAppObject('blank', 'crop-free', 'Zero App'),
            $this->createAppObject('portfolio', 'camera', 'Portfolio'),
            $this->createAppObject('hotel-rooms', 'hotel', 'Hotel Rooms'),
            $this->createAppObject('photo-editor', 'camera-alt', Text::_('PHOTO_EDITOR'), true),
            $this->createAppObject('code-editor', 'code-setting', Text::_('CODE_EDITOR'), true),
            $this->createAppObject('performance', 'time-restore-setting', Text::_('PERFORMANCE'), true),
            $this->createAppObject('preloader', 'spinner', Text::_('PRELOADER'), true),
            $this->createAppObject('canonical', 'link', Text::_('CANONICAL'), true),
            $this->createAppObject('sitemap', 'device-hub', 'XML '.Text::_('SITEMAP'), true)
        ];
    }
}