<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Associations;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Uri\Uri;

class HtmlView extends BaseView
{
    public $apps;
    public $pages;
    public $count;
    public $about;
    public $params;
    public $link;

    public function display ($tpl = null)
    {
        $this->about = GridboxHelper::aboutUs();
        $this->apps = $this->get('Apps');
        $this->pages = $this->get('Pages');
        $this->count = $this->get('PageCount');
        $this->params = $this->get('Params');
        $this->link = "index.php?option=com_gridbox&view=associations&language=".
            $this->params->language."&type=".$this->params->type."&tmpl=component";
        $doc = Factory::getDocument();
        $doc->addScript(Uri::root().'media/vendor/jquery/js/jquery.min.js');
        $doc->addScript('components/com_gridbox/assets/js/ba-associations.js');
        $doc->addStyleSheet('components/com_gridbox/assets/css/ba-admin.css?'.$this->about->version);
        parent::display($tpl);
    }

    public function drawCategoryList($items, $id)
    {
        $str = '<ul>';
        $href = $this->link."&app=".$id."&category=";
        foreach ($items as $key => $item) {
            $str.= '<li><a href="'.$href.$item->id.'"><i class="zmdi zmdi-folder"></i>'.$item->title.'</a>';
            if (count($item->child) > 0) {
                $str .= '<i class="zmdi zmdi-chevron-right ba-icon-md"></i>';
                $str .= $this->drawCategoryList($item->child, $id);
            }
            $str .= '</li>';
        }
        $str .= '</ul>';

        return $str;
    }
}