<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Authors;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\View\BaseView;
use Joomla\CMS\Toolbar\ToolbarHelper;

class HtmlView extends BaseView
{
    protected $items;
    protected $pagination;
    protected $state;
    protected $access = [];
    protected $languages = [];
    protected $apps;
    
    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->apps = GridboxHelper::getApps();
        $this->pagination = $this->get('Pagination');
        $this->state = $this->get('State');
        $this->access = GridboxHelper::getAccess();
        $this->languages = GridboxHelper::getLanguages();
        
        parent::display($tpl);
    }
    
    protected function addToolBar(): void
    {
        if ($this->user->authorise('core.edit.state', 'com_gridbox')) {
            ToolbarHelper::publish('authors.publish', 'JTOOLBAR_PUBLISH', true);
            ToolbarHelper::unpublish('authors.unpublish', 'JTOOLBAR_UNPUBLISH', true);
        }
        if ($this->user->authorise('core.delete', 'com_gridbox')) {
            ToolBarHelper::custom('authors.delete', 'delete.png', 'delete.png', 'DELETE', true);
        }
    }
}