<?php
/**
 * @package   Gridbox
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Gridbox\Administrator\View;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\User;
use Joomla\CMS\WebAsset\WebAssetManager;

class BaseView extends HtmlView
{
    protected Toolbar $toolbar;
    protected User $user;
    protected WebAssetManager $wa;
    protected object $about;

    public function display($tpl = null)
    {
        $this->initializeView();
        $this->registerAssets();
        $this->addToolBar();

        parent::display($tpl);
    }

    protected function initializeView(): void
    {
        $this->toolbar = Toolbar::getInstance();
        $this->user = $this->getCurrentUser();
        $this->wa = $this->getDocument()->getWebAssetManager();
        $this->about = GridboxHelper::aboutUs();
    }

    protected function registerAssets(): void
    {
        $this->wa->useScript('list-view');
        $this->wa->registerAndUseStyle('com_gridbox.admin', 'components/com_gridbox/assets/css/ba-admin.css?'.$this->about->version);
        $this->wa->registerAndUseScript('com_gridbox.jquery', Uri::root().'/media/vendor/jquery/js/jquery.min.js');
    }

    protected function createChildToolbar()
    {
        $dropdown = $this->toolbar->dropdownButton('status-group')
            ->text('MORE_ACTIONS')
            ->toggleSplit(false)
            ->buttonClass('btn btn-action')
            ->listCheck(true);

        return $dropdown->getChildToolbar();
    }

    protected function addToolBar() :void
    {
        if ($this->user->authorise('core.duplicate', 'com_gridbox')) {
            $this->toolbar->standardButton('copy', 'JTOOLBAR_DUPLICATE', 'pages.duplicate')
                ->listCheck(true);
        }
        if ($this->user->authorise('core.edit.state', 'com_gridbox')) {
            $this->toolbar->publish('pages.publish')->listCheck(true);
            $this->toolbar->unpublish('pages.unpublish')->listCheck(true);
        }
        if ($this->user->authorise('core.delete', 'com_gridbox')) {
            $this->toolbar->standardButton('trash', 'JTOOLBAR_TRASH', 'pages.addTrash')
                ->listCheck(true);
        }
        $childBar = $this->createChildToolbar();
        $childBar->standardButton('download', 'EXPORT', 'pages.export')
            ->listCheck(true);
        if ($this->user->authorise('core.edit', 'com_gridbox')) {
            $childBar->standardButton('chevron-right', 'MOVE_TO', 'apps.moveTo')
                ->listCheck(true);
            $childBar->standardButton('brush', 'THEME', 'pages.bulkTheme')
                ->listCheck(true);
            $childBar->standardButton('lock', 'JFIELD_ACCESS_LABEL', 'pages.bulkAccess')
                ->listCheck(true);
            $childBar->standardButton('cloud', 'JFIELD_LANGUAGE_LABEL', 'pages.bulkLanguage')
                ->listCheck(true);
        }
    }
}