<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Bookingcalendar;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

class HtmlView extends BaseView
{
    protected $items;
    protected $about;
    protected $apps;
    protected $settings;
    protected $state;
    protected $services;
    protected $newBookings;
    protected $upcoming;
    protected $colors;
    protected $color;
    protected $blocks;
    protected $info;
    
    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->blocks = $this->get('TimeBlocks');
        $this->state = $this->get('State');
        $this->settings = $this->get('Settings');
        $this->services = $this->get('Services');
        $this->newBookings = $this->get('newBookings');
        $this->upcoming = $this->get('upcoming');
        $this->colors = $this->get('Colors');
        $this->color = (object)[
            'colors' => ['#cdb502', '#ff9391', '#53767c', '#28bacf', '#262626'],
            'default' => '#cdb502'
        ];
        $this->info = $this->get('CustomerInfo');
        $this->about = GridboxHelper::aboutUs();
        $doc = Factory::getDocument();
        $this->apps = GridboxHelper::getApps();
        $doc->addStyleSheet('components/com_gridbox/assets/css/ba-admin.css?'.$this->about->version);
        $doc->addScript(Uri::root().'media/vendor/jquery/js/jquery.min.js');
        
        parent::display($tpl);
    }
}