<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Dashboard;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Uri\Uri;

class HtmlView extends BaseView
{
    protected $about;
    protected $apps;
    protected $widgets;
    protected $allWidgets;
    protected $dashboard;
    protected $access;
    
    public function display($tpl = null) 
    {
        $this->widgets = $this->get('Widgets');
        $this->allWidgets = $this->get('AllWidgets');
        $this->dashboard = $this->get('Dashboard');
        $this->about = GridboxHelper::aboutUs();
        $this->apps = GridboxHelper::getApps();
        $this->access = GridboxHelper::getAccess();
        $doc = Factory::getDocument();
        $doc->addStyleSheet('components/com_gridbox/assets/css/ba-admin.css?1'.$this->about->version);
        $doc->addScript(Uri::root().'media/vendor/jquery/js/jquery.min.js');

        parent::display($tpl);
    }
}