<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Integrations;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Uri\Uri;

class HtmlView extends BaseView
{
    protected $items;
    protected $pagination;
    protected $state;
    protected $about;
    protected $apps;
    
    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->state = $this->get('State');
        $this->about = GridboxHelper::aboutUs();
        $doc = Factory::getDocument();
        $this->apps = GridboxHelper::getApps();
        $this->pagination = $this->get('Pagination');
        foreach ($this->items as &$item) {
            $item->order_up = true;
            $item->order_dn = true;
        }    
        $doc->addStyleSheet('components/com_gridbox/assets/css/ba-admin.css?'.$this->about->version);
        $doc->addScript(Uri::root().'media/vendor/jquery/js/jquery.min.js');
        
        parent::display($tpl);
    }
}