<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Orders;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\View\BaseView;
use Joomla\CMS\Factory;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Uri\Uri;

class HtmlView extends BaseView
{
    protected $items;
    protected $pagination;
    protected $state;
    protected $apps;
    protected $statuses;
    protected $info;
    protected $shipping;
    protected $promo;
    protected $item;
    protected $sales;
    
    public function display($tpl = null): void
    {
        $input = Factory::getApplication()->input;
        $layout = $input->get('layout', '', 'string');
        if ($layout == 'print' || $layout == 'pdf') {
            $this->item = $this->get('Item');
        } else {
            $this->items = $this->get('Items');
            $this->statuses = $this->get('Statuses');
            $this->state = $this->get('State');
            $this->apps = GridboxHelper::getApps();
            $this->pagination = $this->get('Pagination');
            $this->info = $this->get('CustomerInfo');
            $this->shipping = $this->get('Shipping');
            $this->promo = $this->get('Promo');
            $this->sales = $this->get('Sales');
        }

        parent::display($tpl);
    }
    
    protected function addToolBar(): void
    {
        if ($this->user->authorise('core.delete', 'com_gridbox')) {
            ToolbarHelper::custom('orders.delete', 'delete.png', 'delete.png', 'DELETE', true);
        }
        if ($this->user->authorise('core.edit', 'com_gridbox')) {
            ToolBarHelper::custom('orders.exportcsv', 'download.png', 'download.png', 'IMPORT_EXPORT_CSV', false);
        }
    }
}