<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Pages;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\View\BaseView;
use Joomla\CMS\Factory;

class HtmlView extends BaseView
{
    protected $items;
    protected $pagination;
    protected $state;
    protected $themes;
    protected $access = [];
    protected $languages = [];
    protected $apps;
    
    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->state = $this->get('State');
        $app = Factory::getApplication();
        $layout = $app->input->get('layout', '');
        if ($layout != 'apps' && $layout != 'modal') {
            foreach ($this->items as $item) {
                $item->app_type = 'single';
            }
            $this->apps = GridboxHelper::getApps();
            $this->pagination = $this->get('Pagination');
            $this->themes = $this->get('Themes');
            $this->access = GridboxHelper::getAccess();
            $this->languages = GridboxHelper::getLanguages();
        }

        parent::display($tpl);
    }
}