<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Reviews;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\View\BaseView;
use Joomla\CMS\Toolbar\ToolbarHelper;

class HtmlView extends BaseView
{
    protected $items;
    protected $pagination;
    protected $state;
    protected $apps;
    protected $form;
    protected $users;
    protected $reviewsBanList;
    protected $userGroups;
    protected $integrations;
    
    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->form = $this->get('Form');
        $this->state = $this->get('State');
        $this->users = $this->get('Users');
        $this->integrations = $this->get('Integrations');
        $this->userGroups = $this->get('UserGroups');
        $this->reviewsBanList = $this->get('BannedReviewsLists');
        $this->apps = GridboxHelper::getApps();
        $this->pagination = $this->get('Pagination');

        parent::display($tpl);
    }

    protected function addToolBar(): void
    {
        if ($this->user->authorise('core.edit.state', 'com_gridbox')) {
            ToolbarHelper::custom('reviews.approve', 'publish.png', 'publish.png', 'APPROVE', true);
            ToolbarHelper::custom('reviews.spam', 'minus.png', 'minus.png', 'SPAM', true);
        }
        if ($this->user->authorise('core.delete', 'com_gridbox')) {
            ToolbarHelper::custom('reviews.delete', 'delete.png', 'delete.png', 'DELETE', true);
        }
        if ($this->user->authorise('core.edit', 'com_gridbox')) {
            ToolbarHelper::custom('reviews.readAll', 'eye.png', 'eye.png', 'MARK_ALL_AS_READ', false);
            ToolbarHelper::custom('reviews.unread', 'eye-slash.png', 'eye-slash.png', 'MARK_AS_UNREAD', true);
        }
    }
}