<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Sales;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\View\BaseView;
use Joomla\CMS\Toolbar\ToolbarHelper;

class HtmlView extends BaseView
{
    protected $items;
    protected $pagination;
    protected $state;
    protected $apps;
    protected $access;
    
    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->state = $this->get('State');
        $this->apps = GridboxHelper::getApps();
        $this->pagination = $this->get('Pagination');
        $this->access = GridboxHelper::getAccess();
        
        parent::display($tpl);
    }

    protected function addToolBar(): void
    {
        if ($this->user->authorise('core.duplicate', 'com_gridbox')) {
            ToolbarHelper::custom('sales.duplicate', 'copy.png', 'copy_f2.png', 'JTOOLBAR_DUPLICATE', true);
        }
        if ($this->user->authorise('core.edit.state', 'com_gridbox')) {
            ToolbarHelper::publish('sales.publish', 'JTOOLBAR_PUBLISH', true);
            ToolbarHelper::unpublish('sales.unpublish', 'JTOOLBAR_UNPUBLISH', true);
        }
        if ($this->user->authorise('core.delete', 'com_gridbox')) {
            ToolbarHelper::custom('sales.delete', 'delete.png', 'delete.png', 'DELETE', true);
        }
    }
}