<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Shipping;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\View\BaseView;
use Joomla\CMS\Toolbar\ToolbarHelper;

class HtmlView extends BaseView
{
    protected $items;
    protected $pagination;
    protected $state;
    protected $apps;
    protected $carriers;
    
    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->state = $this->get('State');
        $this->apps = GridboxHelper::getApps();
        $this->pagination = $this->get('Pagination');
        $this->carriers = $this->get('Carriers');
        
        parent::display($tpl);
    }

    protected function addToolBar(): void
    {
        if ($this->user->authorise('core.edit.state', 'com_gridbox')) {
            ToolbarHelper::publish('shipping.publish', 'JTOOLBAR_PUBLISH', true);
            ToolbarHelper::unpublish('shipping.unpublish', 'JTOOLBAR_UNPUBLISH', true);
        }
        if ($this->user->authorise('core.delete', 'com_gridbox')) {
            ToolbarHelper::custom('shipping.delete', 'delete.png', 'delete.png', 'DELETE', true);
        }
    }
}