<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Single;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\View\BaseView;
use Joomla\CMS\Factory;

class HtmlView extends BaseView
{
    protected $items;
    protected $pagination;
    protected $single;
    protected $state;
    protected $themes;
    protected $access = [];
    protected $languages = [];
    protected $apps;
    
    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->apps = GridboxHelper::getApps();
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        foreach ($this->apps as $app) {
            if ($app->id == $id) {
                $this->single = $app;
                break;
            }
        }
        foreach ($this->items as $item) {
            $item->app_type = $this->single->type;
        }
        $this->pagination = $this->get('Pagination');
        $this->state = $this->get('State');
        $this->themes = $this->get('Themes');
        $this->access = GridboxHelper::getAccess();
        $this->languages = GridboxHelper::getLanguages();

        parent::display($tpl);
    }

    protected function addToolBar(): void
    {
        parent::addToolBar();
        if ($this->user->authorise('core.delete', 'com_gridbox')) {
            $this->toolbar->standardButton('delete', 'DELETE_APP', 'apps.deleteApp')
                ->listCheck(true);
        }
    }
}