<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Storesettings;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Uri\Uri;

class HtmlView extends BaseView
{
    protected $about;
    protected $apps;
    protected $store;
    protected $customerInfo;
    protected $form;
    protected $integrations;
    protected $languages;
    protected $systemStatuses = [];
    protected $statuses = [];
    
    public function display($tpl = null) 
    {
        $this->about = GridboxHelper::aboutUs();
        $items = $this->get('Items');
        $this->store = $items[0];
        $this->form = $this->get('Form');
        $this->integrations = $this->get('Integrations');
        $this->languages = $this->get('Languages');
        $doc = Factory::getDocument();
        $this->apps = GridboxHelper::getApps();
        $this->customerInfo = $this->get('CustomerInfo');
        $doc->addStyleSheet('components/com_gridbox/assets/css/ba-admin.css?'.$this->about->version);
        $doc->addScript(Uri::root().'media/vendor/jquery/js/jquery.min.js');
        $this->getStatusesList();
        
        parent::display($tpl);
    }

    public function getStatusesList()
    {
        foreach (GridboxHelper::$store->statuses as $status) {
            $this->statuses[$status->key] = $status;
        }
        $array = [
            $this->getStatusObject(Text::_('OUT_OF_STOCK'), '#ff4f49', 'stock'),
            $this->getStatusObject(Text::_('EXPIRATION_RENEWAL_REMINDER'), '#ff4f49', 'reminder'),
            $this->getStatusObject(Text::_('NEW_BOOKING'), '#1da6f4', 'new-booking'),
            $this->getStatusObject(Text::_('APPOINTMENT_REMINDER'), '#ff4f49', 'appointment-reminder')
        ];
        foreach ($array as $obj) {
            $this->systemStatuses[] = $obj->key;
            $this->statuses[$obj->key] = $obj;
        }
    }

    public function getStatusObject(string $title, string $color, string $key):object
    {
        return (object)[
            'title' => $title,
            'color' => $color,
            'key' => $key
        ];
    }
}