<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\System;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\View\BaseView;

class HtmlView extends BaseView
{
    protected $items;
    protected $pagination;
    protected $state;
    protected $themes;
    protected $apps;
    protected $languages = [];
    protected $access = [];
    
    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->state = $this->get('State');
        $this->apps = GridboxHelper::getApps();
        $this->pagination = $this->get('Pagination');
        $this->themes = $this->get('Themes');
        $this->languages = GridboxHelper::getLanguages();
        $this->access = GridboxHelper::getAccess();

        parent::display($tpl);
    }

    protected function addToolBar():void
    {
        if ($this->user->authorise('core.duplicate', 'com_gridbox')) {
            $this->toolbar->standardButton('copy', 'JTOOLBAR_DUPLICATE', 'system.duplicate')
                ->listCheck(true);
        }
        if ($this->user->authorise('core.edit.state', 'com_gridbox')) {
            $this->toolbar->publish('system.publish')->listCheck(true);
            $this->toolbar->unpublish('system.unpublish')->listCheck(true);
        }
        if ($this->user->authorise('core.delete', 'com_gridbox')) {
            $this->toolbar->standardButton('trash', 'JTOOLBAR_TRASH', 'system.addTrash')
                ->listCheck(true);
        }
        if ($this->user->authorise('core.edit', 'com_gridbox')) {
            $childBar = $this->createChildToolbar();
            $childBar->standardButton('cloud', 'JFIELD_LANGUAGE_LABEL', 'system.bulkLanguage')
                ->listCheck(true);
            $childBar->standardButton('brush', 'THEME', 'system.bulkTheme')
                ->listCheck(true);
        }
    }
}