<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Tags;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\View\BaseView;
use Joomla\CMS\Factory;

class HtmlView extends BaseView
{
    protected $items;
    protected $pagination;
    protected $state;
    protected $access = [];
    protected $languages = [];
    protected $apps;
    protected $folders;
    protected $folder;
    
    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->state = $this->get('State');
        $app = Factory::getApplication();
        $layout = $app->input->get('layout', '');
        if ($layout != 'apps' && $layout != 'modal') {
            $this->apps = GridboxHelper::getApps();
            $this->folders = $this->get('Folders');
            $this->folder = $app->input->get('folder', 1, 'int');
            $this->pagination = $this->get('Pagination');
            $this->access = GridboxHelper::getAccess();
            $this->languages = GridboxHelper::getLanguages();
        }
        
        parent::display($tpl);
    }
    
    protected function addToolBar(): void
    {
        if ($this->user->authorise('core.duplicate', 'com_gridbox')) {
            $this->toolbar->standardButton('copy', 'JTOOLBAR_DUPLICATE', 'tags.duplicate')
                ->listCheck(true);
        }
        if ($this->user->authorise('core.edit.state', 'com_gridbox')) {
            $this->toolbar->publish('tags.publish')->listCheck(true);
            $this->toolbar->unpublish('tags.unpublish')->listCheck(true);
        }
        if ($this->user->authorise('core.delete', 'com_gridbox')) {
            $this->toolbar->standardButton('delete', 'DELETE', 'tags.delete')
                ->listCheck(true);
        }
        if ($this->user->authorise('core.edit', 'com_gridbox')) {
            $childBar = $this->createChildToolbar();
            $childBar->standardButton('chevron-right', 'MOVE_TO', 'tags.moveTo')
                ->listCheck(true);
            $childBar->standardButton('lock', 'JFIELD_ACCESS_LABEL', 'tags.bulkAccess')
                ->listCheck(true);
            $childBar->standardButton('cloud', 'JFIELD_LANGUAGE_LABEL', 'tags.bulkLanguage')
                ->listCheck(true);
        }
    }
}