<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Themes;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Uri\Uri;

class HtmlView extends BaseView
{
    protected $items;
    protected $state;
    protected $about;
    protected $apps;
    protected $plugins;

    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->apps = GridboxHelper::getApps();
        $this->plugins = $this->get('Plugins');
        foreach ($this->items as $key => $item) {
            if (empty($item->params)) {
                $item->params = '{}';
            }
            $params = json_decode($item->params);
            if (!isset($params->image) || empty($params->image)) {
                $params->image = 'components/com_gridbox/assets/images/default-theme.png';
            } else if (strpos($params->image, 'https://') === false && strpos($params->image, 'http://') === false) {
                $params->image = '../'.$params->image;
            }
            unset($this->items[$key]->params);
            $this->items[$key]->image = $params->image;
        }
        $this->state = $this->get('State');
        $this->about = GridboxHelper::aboutUs();
        $doc = Factory::getDocument();
        $doc->addStyleSheet('components/com_gridbox/assets/css/ba-admin.css?'.$this->about->version);
        $doc->addScriptDeclaration('var installedPlugins = '.$this->plugins.';');
        $doc->addScript(Uri::root().'media/vendor/jquery/js/jquery.min.js');
        foreach ($this->items as &$item) {
            $item->order_up = true;
            $item->order_dn = true;
        }
        
        parent::display($tpl);
    }
}