<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Trashed;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\View\BaseView;
use Joomla\CMS\Toolbar\ToolbarHelper;

class HtmlView extends BaseView
{
    protected $items;
    protected $pagination;
    protected $state;
    protected $apps;
    protected $themes;
    protected $languages = [];
    
    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->apps = GridboxHelper::getApps();
        $this->pagination = $this->get('Pagination');        
        $this->state = $this->get('State');
        $this->themes = $this->get('Themes');
        $this->languages = GridboxHelper::getLanguages();

        parent::display($tpl);
    }
    
    protected function addToolBar(): void
    {
        if ($this->user->authorise('core.delete', 'com_gridbox')) {
            ToolbarHelper::deleteList('', 'trashed.delete');
        }
    }
}