<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\View\Uploader;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Uri\Uri;

class HtmlView extends BaseView
{
    protected $_limit;
    protected $about;
    protected $version;
    protected $uploader;
    
    public function display ($tpl = null)
    {
        if (count($errors = $this->get('Errors'))) {
            throw new \Exception(implode('<br />', $errors), 500);
        }
        $this->uploader = $this->get('Uploader');
        $this->about = GridboxHelper::aboutUs();
        $this->version = $this->about->version;
        $this->_limit = $this->uploader->limit;
        $doc = Factory::getDocument();
        $doc->addScript(Uri::root().'media/vendor/jquery/js/jquery.min.js');
        if ($doc->getDirection() == 'rtl') {
            $doc->addStyleSheet(Uri::root().'components/com_gridbox/assets/css/rtl-ba-style.css?'.$this->about->version);
        }
        $this->addToolBar();
        parent::display($tpl);
    }

    protected function addToolBar()
    {
        $input = Factory::getApplication()->input;
        $input->set('hidemainmenu', true);
    }
}