<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\Helper\HtmlJgridHelper;
use Balbooa\Component\Gridbox\Site\Helper\AssetsHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

?>
<table class="table table-striped">
    <thead>
        <tr>
            <th>
                <label class="ba-hide-checkbox">
                    <input type="checkbox" name="checkall-toggle" value=""
                           title="<?php echo Text::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                    <i class="zmdi zmdi-check-circle check-all"></i>
                </label>
            </th>
            <th class="status-th <?php echo $listOrder == 'published' ? 'active' : ''; ?>">
                <span data-sorting="published">
                    <?php echo Text::_('JSTATUS'); ?>
                    <span class="ba-tooltip ba-top ba-hide-element">
                        <?php echo Text::_('SORT_BY_COLUMN'); ?>
                    </span>
                </span>
                <div class="state-filter">
                    <div class="ba-custom-select">
                        <input type="hidden" data-name="filter_state" value="<?php echo $state; ?>">
                        <i class="zmdi zmdi-caret-down"></i>
                        <ul>
                            <li data-value="">
                                <?php echo Text::_('JSTATUS');?>
                            </li>
                            <li data-value="1" >
                                <?php echo Text::_('JPUBLISHED');?>
                            </li>
                            <li data-value="0">
                                <?php echo Text::_('JUNPUBLISHED');?>
                            </li>
                        </ul>
                    </div>
                </div>
            </th>
            <th class="<?php echo $listOrder == 'title' ? 'active' : ''; ?>">
                <span data-sorting="title">
                    <?php echo Text::_('JGLOBAL_TITLE'); ?>
                    <span class="ba-tooltip ba-top ba-hide-element">
                        <?php echo Text::_('SORT_BY_COLUMN'); ?>
                    </span>
                </span>
            </th>
            <th class="<?php echo $listOrder == 'price' ? 'active' : ''; ?> price-column">
                <span data-sorting="price">
                    <?php echo Text::_('PRICE'); ?>
                    <span class="ba-tooltip ba-top ba-hide-element">
                        <?php echo Text::_('SORT_BY_COLUMN'); ?>
                    </span>
                </span>
            </th>
            <th class="<?php echo $listOrder == 'page_category' ? 'active' : ''; ?>">
                <span data-sorting="page_category">
                    <?php echo Text::_('CATEGORY'); ?>
                    <span class="ba-tooltip ba-top ba-hide-element">
                        <?php echo Text::_('SORT_BY_COLUMN'); ?>
                    </span>
                </span>
            </th>
            <th class="<?php echo $listOrder == 'hits' ? 'active' : ''; ?>">
                <span data-sorting="hits">
                    <?php echo Text::_('VIEWS'); ?>
                    <span class="ba-tooltip ba-top ba-hide-element">
                        <?php echo Text::_('SORT_BY_COLUMN'); ?>
                    </span>
                </span>
            </th>
            <th class="<?php echo $listOrder == 'id' ? 'active' : ''; ?>">
                <span data-sorting="id">
                    <?php echo Text::_('ID'); ?>
                    <span class="ba-tooltip ba-top ba-hide-element ba-blog-id-tooltip">
                        <?php echo Text::_('SORT_BY_COLUMN'); ?>
                    </span>
                </span>
            </th>
        </tr>
    </thead>
    <tbody class="<?php echo str_replace('_', '-', $listOrder); ?>-sorting"
        data-category="<?php echo !empty($this->category) ? $this->category : 'root'; ?>">
<?php
    foreach ($this->items as $i => $item) {
        $str = json_encode($item);
        $pageAssets = new AssetsHelper($item->id, 'page');
        $canChange = $pageAssets->checkPermission('core.edit.state');
        $editPage = $pageAssets->checkPermission('core.edit');
        if (!$editPage) {
            $editPage = $pageAssets->checkEditOwn($item->page_category);
        }
        if (!empty($item->intro_image)) {
            $introStr = '<span class="post-intro-image" style="background-image: url(';
            if (strpos($item->intro_image, 'https://') === false && strpos($item->intro_image, 'http://') === false) {
                $introStr .= Uri::root().str_replace(' ', '%20', $item->intro_image);
            } else {
                $introStr .= $item->intro_image;
            }
            $introStr .= ');"></span>';
        } else {
            $introStr = '';
        }
        $category = [$item->category];
        foreach ($item->categories as $obj) {
            $category[] = $obj->title;
        }
?>
        <tr>
            <td class="select-td">
                <label class="ba-hide-checkbox">
                    <?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
                    <i class="zmdi zmdi-circle-o ba-icon-md"></i>
                    <i class="zmdi zmdi-check ba-icon-md"></i>
                </label>
                <input type="hidden"
                       value='<?php echo htmlspecialchars($str, ENT_QUOTES); ?>'>
            </td>
            <td class="status-td">
<?php
            if ($canChange) {
                echo HtmlJgridHelper::published($item->published, $i, 'pages.', $canChange);
            } else {
                $published = '<a class="disabled" href="javascript:void(0);"><i class="'.
                    ($item->published == 1 ? 'zmdi zmdi-eye' : 'zmdi zmdi-eye-off').
                    ' ba-icon-md"></i><span class="ba-tooltip ba-hide-element ba-top">'.
                    ($item->published == 1 ? Text::_('JPUBLISHED') : Text::_('JUNPUBLISHED')).'</span></a>';
                echo $published;
            }
            if ($item->featured == 1) {
?>
                <span class="featured-post-wrapper active">
                    <i class="zmdi zmdi-star ba-icon-md set-featured-post" data-featured="0"></i>
                    <span class="ba-tooltip ba-hide-element ba-top">
                        <?php echo Text::_('FEATURED') ?>
                    </span>
                </span>
<?php
            } else {
?>
                <span class="featured-post-wrapper">
                    <i class="zmdi zmdi-star ba-icon-md set-featured-post" data-featured="1"></i>
                    <span class="ba-tooltip ba-hide-element ba-top">
                        <?php echo Text::_('FEATURED') ?>
                    </span>
                </span>
<?php
            }
?>
            </td>
            <td class="title-cell">
<?php
            if ($editPage) {
?>
                <a target="_blank"
                   href="<?php echo 'index.php?option=com_gridbox&task=gridbox.edit&id='. $item->id; ?>">
<?php
            } else {
?>
                <span class="not-permitted-wrapper">
<?php
            }
?>
                    <?php echo $introStr; ?>
                    <?php echo $item->title; ?>
                    <input type="hidden" name="order[]" value="<?php echo $item->order_list; ?>">
                    <input type="hidden" name="root_order[]" value="<?php echo $item->root_order_list; ?>">
<?php
            if ($editPage) {
?>
                </a>
<?php
            } else {
?>
                </span>
<?php
            }
?>
            </td>
            <td class="price-cell">
<?php
                echo GridboxHelper::preparePrice($item->price);
?>
            </td>
            <td class="category-cell">
                <?php echo implode(', ', $category); ?>
            </td>
            <td class="hits-cell">
                <?php echo $item->hits; ?>
            </td>
            <td>
                <?php echo $item->id; ?>
            </td>
        </tr>
<?php
    }
?>
    </tbody>
</table>