<?php

use Joomla\CMS\Language\Text;
use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;

$apps = GridboxHelper::getApps();
?>

<div class="ba-dashboard-widget widget-sm" data-widget="apps" data-ind="<?php echo $ind; ?>">
    <table class="table table-striped">
        <thead class="ba-widget-header grid-sorting-handle">
            <tr>
                <th>
                    <span class="ba-widget-header-title">
                        <?php echo $widget->title; ?>
                    </span>
                    <i class="zmdi zmdi-more-vert trigger-context-menu"
                        data-context="widget-settings-context-menu"></i>
                </th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="ba-widget-title-td">
                    <a href="index.php?option=com_gridbox&view=pages">
                        <div class="ba-widget-image gridbox-app-item-single">
                            <i class="zmdi zmdi-file"></i>
                        </div>
                        <div class="ba-widget-content">
                            <span class="ba-widget-title"><?php echo Text::_('PAGES'); ?></span>
                        </div>
                    </a>
                </td>
            </tr>
<?php

        foreach ($apps as $app) {
            $view = $app->type == 'single' ? 'single' : 'apps';
            $viewLink = 'index.php?option=com_gridbox&view='.$view.'&id='.$app->id;
?>
            <tr>
                <td class="ba-widget-title-td">
                    <a href="<?php echo $viewLink; ?>">
                        <div class="ba-widget-image gridbox-app-item-<?php echo $app->type; ?>">
                            <i class="<?php echo GridboxHelper::getIcon($app); ?>"></i>
                        </div>
                        <div class="ba-widget-content">
                            <span class="ba-widget-title"><?php echo $app->title; ?></span>
                        </div>
                    </a>
                </td>
            </tr>
<?php
        }
?>
        </tbody>
    </table>
    <div class="gridbox-app-item-footer">
        <a href="index.php?option=com_gridbox&view=appslist">
            <i class="zmdi zmdi-widgets"></i>
        </a>
    </div>
</div>