<?php

use Joomla\CMS\Uri\Uri;
use Balbooa\Component\Gridbox\Site\Helper\Dashboard\BookingHelper;
use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;


$appointments = BookingHelper::make()->getItems($widget->sorting);
?>

<div class="ba-dashboard-widget widget-sm" data-widget="booking" data-ind="<?php echo $ind; ?>">
    <table class="table table-striped">
        <thead class="ba-widget-header grid-sorting-handle">
            <tr>
                <th>
                    <span class="ba-widget-header-title">
                        <?php echo $widget->title; ?>
                    </span>
                    <i class="zmdi zmdi-more-vert trigger-context-menu"
                        data-context="widget-settings-context-menu"></i>
                </th>
            </tr>
        </thead>
        <tbody>
            
<?php

        foreach ($appointments as $item) {
            $date = GridboxHelper::formatDate($item->start_date);
            $date .= (!empty($item->end_date) ? (' - '.GridboxHelper::formatDate($item->end_date)) : '');
            $date .= (!empty($item->start_time) ? (', '.$item->start_time.' - '.$item->end_time) : '');
            $style = '';
            if (!empty($item->image)) {
                $image = (GridboxHelper::isExternal($item->image) ? '' : Uri::root()).$item->image;
                $style = 'style="background-image: url(' . $image . ')"';
            }
?>
            <tr data-id="<?php echo $item->id; ?>" data-unread="<?php echo $item->unread == 1 ?>">
                <td class="ba-widget-title-td">
                    <div class="ba-widget-image" <?php echo $style ?>>
<?php
                    if (empty($item->image)) {
?>
                        <i class="zmdi zmdi-calendar-check ba-widget-icon"></i>
<?php
                    }
?>
                    </div>
                    <div class="ba-widget-content">
                        <span class="ba-widget-title"><?php echo $item->title; ?></span>
                        <span class="ba-widget-text"><?php echo $date; ?></span>
                    </div>
                </td>
            </tr>
<?php
        }
?>
        </tbody>
    </table>
    <div class="gridbox-app-item-footer">
        <a href="index.php?option=com_gridbox&view=bookingcalendar">
            <i class="zmdi zmdi-calendar-note"></i>
        </a>
    </div>
</div>