<?php

use Joomla\CMS\Language\Text;
use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Site\Helper\Dashboard\CommentsHelper;

$comments = CommentsHelper::make()->getItems();
?>
<div class="ba-dashboard-widget widget-sm" data-widget="comments" data-ind="<?php echo $ind; ?>">
    <table class="table table-striped">
        <thead class="ba-widget-header grid-sorting-handle">
            <tr>
                <th>
                    <span class="ba-widget-header-title">
                        <?php echo $widget->title; ?>
                    </span>
                    <i class="zmdi zmdi-more-vert trigger-context-menu"
                        data-context="widget-settings-context-menu"></i>
                </th>
            </tr>
        </thead>
        <tbody>
<?php
        
        foreach ($comments as $comment) {
            $timestamp = strtotime($comment->date);
            if (!empty($comment->user_email)) {
                $comment->email = $comment->user_email;
            }
            $avatar = $comment->avatar;
            if (empty($avatar)) {
                $author = GridboxHelper::getAuthor($comment->user_id);
                $comment->name = $author->title ?? $comment->name;
                $avatar = GridboxHelper::getUserAvatar($comment->email, 'enable_gravatar', $author);
            }
            $date = date('Y-m-d', $timestamp);
?>
            <tr>
                <td class="ba-widget-title-td">
                    <div class="ba-widget-image"
                        style="background-image: url(<?php echo str_replace(' ', '%20', $avatar); ?>);">
                    </div>
                    <img src="<?php echo $avatar; ?>" style="display: none !important;"
                        onerror="setGravatarDefault(this);">
                    <div class="ba-widget-content">
                        <span class="ba-widget-title">
                            <span class="ba-widget-title-left">
                                <?php echo $comment->name; ?>
                            </span>
                            <span class="ba-widget-title-right">
                                <?php echo $date; ?>
                            </span>
                        </span>
                        <span class="ba-widget-text"><?php echo $comment->message; ?></span>
                    </div>
                </td>
            </tr>
<?php
        }
?>
        </tbody>
    </table>
    <div class="gridbox-app-item-footer">
        <a href="index.php?option=com_gridbox&view=comments">
            <i class="zmdi zmdi-comment-more"></i>
        </a>
    </div>
</div>