<?php
/**
* @package   gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\Helper\SidebarHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;
$user = Factory::getUser();
$createUrl = GridboxHelper::getEditorLink().'&app_id=';
$gridboxStateStr = GridboxHelper::checkGridboxState();
$gridboxState = json_decode($gridboxStateStr);
$gridboxStateCount = !isset($gridboxState->data) ? 1 : 0;
$sidebar = SidebarHelper::make()::getSidebar();
$rules = (object) [
    'sales' => GridboxHelper::checkInstalledBlog('products'),
    'reviews' => GridboxHelper::checkSystemApp('reviews'),
    'comments' => GridboxHelper::checkSystemApp('comments'),
    'booking' => GridboxHelper::checkInstalledBlog('booking')
];
?>
<script src="components/com_gridbox/assets/js/ba-admin.js?<?php echo $this->about->version; ?>"
    ></script>
<script src="<?php echo Uri::root(); ?>components/com_gridbox/libraries/chart/chart.js"></script>
<script>
    if (!window.Joomla) {
        window.Joomla = {};
    }
    app.store = <?php echo json_encode(GridboxHelper::$store); ?>;
    app.dashboard = <?php echo json_encode($this->dashboard); ?>;
    app.widgets = <?php echo json_encode($this->allWidgets); ?>;
</script>
<?php
include(JPATH_COMPONENT.'/tmpl/layouts/calendar.php');
include(JPATH_COMPONENT.'/tmpl/layouts/notification.php');
?>
<div id="uploader-modal" class="ba-modal-lg modal ba-modal-dialog hide" style="display:none" data-check="multiple">
    <div class="modal-body">
        <iframe src="javascript:''" name="uploader-iframe"></iframe>
        <input type="hidden" data-dismiss="modal">
    </div>
</div>
<div id="delete-dialog" class="ba-modal-sm modal hide" style="display:none">
    <div class="modal-body">
        <h3><?php echo Text::_('DELETE_ITEM'); ?></h3>
        <p class="modal-text"><?php echo Text::_('MODAL_DELETE') ?></p>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL') ?>
        </a>
        <a href="#" class="ba-btn-primary red-btn" id="apply-delete">
            <?php echo Text::_('DELETE') ?>
        </a>
    </div>
</div>
<form autocomplete="off" action="<?php echo Route::_('index.php?option=com_gridbox'); ?>" method="post" name="adminForm" id="adminForm">
    <div class="row-fluid">
        <div id="gridbox-container">
            <div id="gridbox-content">
<?php
                include(JPATH_COMPONENT.'/tmpl/layouts/sidebar.php');
?>
                <div class="ba-main-view">
                    <div id="filter-bar">
                        <div class="app-title-wrapper">
                            <h1><?php echo Text::_('DASHBOARD'); ?></h1>
                            <span class="ba-dashboard-popover-trigger" data-target="ba-dashboard-apps-list">
                                <i class="zmdi zmdi-plus-circle"></i>
                                <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('ADD_NEW_ITEM'); ?></span>
                            </span>
                        </div>
                        <div class="filter-dashboars-icons-wrapper">
<?php
                        if ($user->authorise('core.tools', 'com_gridbox')) {
?>
                            <span class="ba-dashboard-popover-trigger"
                                data-target="ba-dashboard-settings">
                                <i class="zmdi zmdi-settings"></i>
                                <span class="ba-tooltip ba-top ba-hide-element">
                                    <?php echo Text::_('DASHBOARD_SETTINGS'); ?>
                                </span>
                            </span>
                            <span class="ba-dashboard-popover-trigger"
                                data-target="ba-dashboard-about">
                                <i class="<?php echo ($gridboxStateCount == 0) ? 'zmdi zmdi-info"' : 'zmdi zmdi-notifications'; ?>"></i>
                                <span class="about-notifications-count"
                                <?php echo ($gridboxStateCount == 0) ? ' style="display: none;"' : '' ?>>
                                <?php echo $gridboxStateCount; ?></span>
                                <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('ABOUT_GRIDBOX'); ?></span>
                            </span>
                            <span class="gridbox-languages">
                                <i class="zmdi zmdi-globe"></i>
                                <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('LANGUAGES'); ?></span>
                            </span>
                            <?php
                        }
?>
                        </div>
                    </div>
                    <div class="main-table dashboard-content">
                        <div class="dashboard-content-wrapper">
<?php
                            foreach ($this->dashboard->widgets as $ind => $widget) {
                                if ((isset($rules->{$widget->type}) && !$rules->{$widget->type})
                                    || (!in_array($widget->access, $user->getAuthorisedViewLevels()))) {
                                    continue;
                                }
                                include $widget->type . '.php';
                            }

?>
                        </div>
<?php
                        if ($user->authorise('core.tools', 'com_gridbox')) {
?>
                        <div class="add-dashboard-widget-wrapper">
                            <span class="ba-dashboard-popover-trigger" data-target="ba-dashboard-widgets-list">
                                <i class="zmdi zmdi-plus-circle add-dashboard-widget"></i>
                                <span class="ba-tooltip ba-top ba-hide-element">
                                    <?php echo Text::_('ADD_WIDGET'); ?>
                                </span>
                            </span>
                        </div>
<?php
                        }
?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<div class="ba-dashboard-apps-dialog ba-dashboard-apps-list">
    <div class="ba-dashboard-apps-body">
<?php
    if (SidebarHelper::checkAccess($sidebar->access->{'0'} ?? null)) {
?>
        <div class="ba-gridbox-dashboard-row">
            <a href="<?php echo $createUrl.'0&id='; ?>" target="_blank" class="gridbox-app-item-single">
                <i class="zmdi zmdi-file"></i>
                <span><?php echo Text::_('PAGES'); ?></span>
            </a>
        </div>
<?php
    }
    foreach ($this->apps as $app) {
        if (!SidebarHelper::checkAccess($sidebar->access->{$app->id} ?? null)) {
            continue;
        }
?>
        <div class="ba-gridbox-dashboard-row">
            <a href="<?php echo $createUrl.$app->id.'&id='; ?>" target="_blank"
                class="gridbox-app-item-<?php echo $app->type; ?>">
                <i class="<?php echo GridboxHelper::getIcon($app); ?>"></i>
                <span><?php echo $app->title; ?></span>
            </a>
        </div>
<?php
    }
?>
    </div>
</div>
<div class="ba-dashboard-apps-dialog ba-dashboard-about">
    <div class="ba-dashboard-apps-body">
        <div class="ba-gridbox-dashboard-row gridbox-version-wrapper">
            <i class="zmdi zmdi-info"></i>
            <span>Gridbox</span>
            <span class="gridbox-version"><?php echo $this->about->version; ?></span>
        </div>
        <div class="ba-gridbox-dashboard-row gridbox-app-item-blog gridbox-deactivate-license"
            <?php echo isset($gridboxState->data) ? '' : 'style="display:none;"'; ?>>
            <i class="zmdi zmdi-shield-check"></i>
            <span><?php echo Text::_('YOUR_LICENSE_ACTIVE'); ?></span>
            <a class="deactivate-link dashboard-link-action" href="#"><?php echo Text::_('DEACTIVATE'); ?></a>
        </div>
        <div class="ba-gridbox-dashboard-row gridbox-app-item-blog gridbox-activate-license"
            <?php echo !isset($gridboxState->data) ? '' : 'style="display:none;"'; ?>>
            <i class="zmdi zmdi-shield-check"></i>
            <span><?php echo Text::_('ACTIVATE_LICENSE'); ?></span>
            <a class="activate-link dashboard-link-action" href="#"><?php echo Text::_('ACTIVATE'); ?></a>
        </div>
<?php
    if ($user->authorise('core.edit', 'com_gridbox')) {
?>
        <div class="ba-gridbox-dashboard-row gridbox-app-item-blog gridbox-update-wrapper">
            <i class="zmdi zmdi-check-circle"></i>
            <span><?php echo Text::_('GRIDBOX_IS_UP_TO_DATE'); ?></span>
        </div>
<?php
    }
?>
    </div>
    <div class="ba-dashboard-apps-footer">
        <span>© <?php echo date('Y'); ?> <a href="https://www.balbooa.com/" target="_blink">Balbooa.com</a> All Rights Reserved.</span>
    </div>
</div>
<div id="deactivate-dialog" class="ba-modal-sm modal hide" style="display:none">
    <div class="modal-body">
        <h3><?php echo Text::_('LICENSE_DEACTIVATION'); ?></h3>
        <p class="modal-text"><?php echo Text::_('ARE_YOU_SURE_DEACTIVATE') ?></p>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL') ?>
        </a>
        <a href="#" class="ba-btn-primary red-btn" id="apply-deactivate">
            <?php echo Text::_('APPLY') ?>
        </a>
    </div>
</div>
<?php
if ($user->authorise('core.tools', 'com_gridbox')) {
?>
<div class="edit-dashboard-wrapper">
    <label class="ba-checkbox toggle-btn toggle-btn-blue">
        <input type="checkbox" class="edit-dashboard">
        <span></span>
    </label>
    <span class="ba-tooltip ba-hide-element ba-bottom">
        <?php echo Text::_('EDIT_DASHBOARD'); ?>
    </span>
</div>
<div class="ba-dashboard-apps-dialog ba-dashboard-settings">
    <div class="ba-dashboard-apps-body">
        <div class="ba-gridbox-dashboard-row">
            <i class="zmdi zmdi-star"></i>
            <span><?php echo Text::_('LOGIN_REDIRECT_DASHBOARD') ?></span>
            <label class="ba-checkbox toggle-btn toggle-btn-green">
                <input type="checkbox" data-option="redirect"
                    <?php echo $this->dashboard->settings->redirect ? 'checked' : '' ?>>
                <span></span>
            </label>
        </div>
        <div class="ba-gridbox-dashboard-row">
            <i class="zmdi zmdi-eye-off"></i>
            <span><?php echo Text::_('HIDE_JOOMLA_NAVIGATION') ?></span>
            <label class="ba-checkbox toggle-btn toggle-btn-green">
                <input type="checkbox" data-option="navigation"
                <?php echo $this->dashboard->settings->navigation ? 'checked' : '' ?>>
                <span></span>
            </label>
        </div>
    </div>
</div>
<div id="widget-settings-modal" class="ba-modal-sm modal ba-modal-dialog hide" style="display: none;">
    <div class="modal-header">
        <h3 class="ba-modal-header"><?php echo Text::_('SETTINGS'); ?></h3>
    </div>
    <div class="modal-body">
        <div class="ba-input-lg">
            <input type="text" class="reset-input-margin"
                data-option="title" placeholder="<?php echo Text::_('JGLOBAL_TITLE'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-custom-select ba-custom-select-lg pages-widget-options">
            <input type="text" readonly class="reset-input-margin">
            <input type="hidden" data-option="sorting">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <li data-value="saved_time"><?php echo Text::_('RECENTLY_OPENED'); ?></li>
                <li data-value="id"><?php echo Text::_('RECENTLY_CREATED'); ?></li>
                <li data-value="hits"><?php echo Text::_('MOST_POPULAR'); ?></li>
            </ul>
        </div>
        <div class="ba-custom-select ba-custom-select-lg booking-widget-options">
            <input type="text" readonly class="reset-input-margin">
            <input type="hidden" data-option="sorting">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <li data-value="new"><?php echo Text::_('NEW_BOOKINGS'); ?></li>
                <li data-value="upcoming"><?php echo Text::_('UPCOMING'); ?></li>
            </ul>
        </div>
        <div class="ba-custom-select ba-custom-select-lg">
            <input type="text" readonly>
            <input type="hidden" data-option="access">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
<?php
                foreach ($this->access as $key => $access) {
?>
                    <li data-value="<?php echo $key; ?>"><?php echo $access ?></li>
<?php
                }
?>
            </ul>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal"><?php echo Text::_('CANCEL') ?></a>
        <a href="#" class="ba-btn-primary apply-widget-settings active-button">
            <?php echo Text::_('JTOOLBAR_APPLY') ?>
        </a>
    </div>
</div>
<div id="quick-link-settings-modal" class="ba-modal-sm modal ba-modal-dialog hide" style="display: none;">
    <div class="modal-header">
        <h3 class="ba-modal-header"><?php echo Text::_('SETTINGS'); ?></h3>
    </div>
    <div class="modal-body">
        <div class="ba-input-lg">
            <input type="text" class="reset-input-margin" required
                data-option="title" placeholder="<?php echo Text::_('JGLOBAL_TITLE'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-input-lg">
            <input type="text" class="reset-input-margin" required
                data-option="link" placeholder="<?php echo Text::_('LINK'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-input-lg">
            <input type="text" class="input-with-icon" readonly onfocus="this.blur()"
                data-option="icon" placeholder="<?php echo Text::_('ICON'); ?>">
            <i class="zmdi zmdi-attachment-alt"></i>
            <div class="reset disabled-reset reset-share-image">
                <i class="zmdi zmdi-close"></i>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal"><?php echo Text::_('CANCEL') ?></a>
        <a href="#" class="ba-btn-primary apply-quick-link active-button">
            <?php echo Text::_('JTOOLBAR_APPLY') ?>
        </a>
    </div>
</div>
<div class="ba-dashboard-apps-dialog ba-dashboard-widgets-list" data-position="top">
    <div class="ba-dashboard-apps-body">
<?php
        foreach ($this->widgets as $type => $widget) {
            if (isset($rules->{$type}) && !$rules->{$type}) {
                continue;
            }
?>
        <div class="ba-gridbox-dashboard-row">
            <a href="#" data-widget="<?php echo $type; ?>">
                <i class="<?php echo $widget->icon; ?>"></i>
                <span><?php echo $widget->title; ?></span>
            </a>
        </div>
<?php
        }
?>
    </div>
</div>
<div class="ba-context-menu widget-settings-context-menu" style="display: none">
    <span class="edit-dashboard-widget">
        <i class="zmdi zmdi-settings"></i>
        <?php echo Text::_('EDIT'); ?>
    </span>
    <span class="delete-dashboard-widget ba-group-element">
        <i class="zmdi zmdi-delete"></i>
        <?php echo Text::_('DELETE'); ?>
    </span>
</div>
<div class="ba-context-menu quick-link-settings-context-menu" style="display: none">
    <span class="edit-dashboard-quick-link">
        <i class="zmdi zmdi-settings"></i>
        <?php echo Text::_('EDIT'); ?>
    </span>
    <span class="delete-dashboard-quick-link ba-group-element">
        <i class="zmdi zmdi-delete"></i>
        <?php echo Text::_('DELETE'); ?>
    </span>
</div>
<?php
}
?>
<template class="ba-store-statistic-product-template">
    <div class="ba-store-statistic-product" data-type="">
        <div class="ba-store-statistic-product-image">
            <i class="ba-widget-icon"></i>
        </div>
        <div class="ba-store-statistic-product-content">
            <span  class="ba-store-statistic-product-title-wrapper">
                <span class="ba-store-statistic-product-title"></span>
                <span class="ba-store-statistic-product-description">
                    <span class="ba-store-statistic-product-info">
                        
                    </span>
                </span>
            </span>
            <span class="ba-store-statistic-product-sales-wrapper">
                <span class="ba-store-statistic-product-sales">
                    <span class="ba-store-statistic-product-sales-count"></span>
                    <span class="ba-store-statistic-product-sales-text">
                        <?php echo Text::_('SALES_STATISTICS') ?>
                    </span>
                </span>
                <span class="ba-store-statistic-price"></span>
            </span>
        </div>
        <a href="" target="_blank"></a>
    </div>    
</template>
<div id="languages-dialog" class="ba-modal-sm modal hide" style="display:none">
    <div class="modal-body">
        <div class="languages-wrapper">

        </div>
    </div>
</div>
<?php
include JPATH_COMPONENT . '/tmpl/layouts/context.php';
include JPATH_COMPONENT . '/tmpl/layouts/photo-editor.php';
include JPATH_COMPONENT . '/tmpl/layouts/login-modal.php';