<?php

use Balbooa\Component\Gridbox\Site\Helper\Dashboard\FilesHelper;
use Joomla\CMS\Uri\Uri;
use Balbooa\Component\Gridbox\Site\Helper\FileHelper;

$files = FilesHelper::make()->getItems();
?>

<div class="ba-dashboard-widget widget-sm" data-widget="files" data-ind="<?php echo $ind; ?>">
    <table class="table table-striped">
        <thead class="ba-widget-header grid-sorting-handle">
            <tr>
                <th>
                    <span class="ba-widget-header-title">
                        <?php echo $widget->title; ?>
                    </span>
                    <i class="zmdi zmdi-more-vert trigger-context-menu"
                        data-context="widget-settings-context-menu"></i>
                </th>
            </tr>
        </thead>
        <tbody>
<?php
        $img = Uri::root().'administrator/index.php?option=com_gridbox&task=uploader.showImage&image=';
        $now = strtotime('now');
        foreach ($files as $file) {
            if ($file->ext == 'svg' || $file->ext == 'ico') {
                $url = $file->url;
            } else if (in_array($file->ext, FileHelper::$imageTypes)) {
                $url = $img . urlencode($file->path) . '&time='.$now;
            }
            if (in_array($file->ext, FileHelper::$imageTypes)) {
                $imageFlag = true;
                $url = str_replace(' ', '%20', $url);
            } else {
                $imageFlag = false;
            }
?>
            <tr>
                <td class="ba-widget-title-td">

                    <div class="ba-widget-image"
                        <?php echo $imageFlag ? 'style="background-image: url(' . $url . ')"' : '' ?>>
<?php
                    if (!$imageFlag) {

?>
                        <i class="zmdi zmdi-file ba-widget-icon"></i>
<?php
                    }
?>
                    </div>

                    <div class="ba-widget-content">
                        <span class="ba-widget-title">
                            <span class="ba-widget-title-left">
                                <?php echo $file->title; ?>
                            </span>
                            <span class="ba-widget-title-right">
                                <?php echo $file->size; ?>
                            </span>
                        </span>
                        
                    </div>
                </td>
            </tr>
<?php
        }
?>
        </tbody>
    </table>
    <div class="gridbox-app-item-footer">
        <a href="#" class="dashboard-view-media-manager">
            <i class="zmdi zmdi-folder"></i>
        </a>
    </div>
</div>