<?php

use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Site\Helper\Dashboard\PagesHelper;
use Joomla\CMS\Factory;

$pages = PagesHelper::make()->getItems($widget->sorting);
$user = Factory::getUser();
?>

<div class="last-edit-pages ba-dashboard-widget widget-md" data-widget="pages"
    data-ind="<?php echo $ind; ?>">
<?php
$count = count($pages);
if ($count > 0) {
?>
    <table class="table table-striped">
        <thead class="ba-widget-header grid-sorting-handle">
            <tr>
                <th>
                    <span class="ba-widget-header-title">
                        <?php echo $widget->title; ?>
                    </span>
                </th>
                <th>
                    <span>
                        <?php echo Text::_('VIEWS'); ?>
                    </span>
                </th>
                <th>
                    <span>
                        <?php echo Text::_('ID'); ?>
                    </span>
                    <i class="zmdi zmdi-more-vert trigger-context-menu"
                        data-context="widget-settings-context-menu"></i>
                </th>
            </tr>
        </thead>
        <tbody>
<?php
        foreach ($pages as $page) {
            $img = GridboxHelper::prepareIntroImage($page->intro_image);
            if (!empty($page->page_category) && !empty($img)) {
                $introStr = '<span class="post-intro-image" style="background-image: url(';
                if (!GridboxHelper::isExternal($img)) {
                    $introStr .= str_replace(' ', '%20', Uri::root().$img);
                } else {
                    $introStr .= $img;
                }
                $introStr .= ');"></span>';
            } else {
                $introStr = '<span class="post-intro-image gridbox-app-item-';
                if (!empty($page->type)) {
                    $introStr .= $page->type;
                } else {
                    $introStr .= 'single';
                }
                $introStr .= '"><i class="'.GridboxHelper::getIcon($page).'"></i></span>';
            }
?>
            <tr>
                <td class="title-cell">
<?php
                if ($user->authorise('core.edit', 'com_gridbox.page.'.$page->id)) {
?>
                    <a target="_blank"
                        href="index.php?option=com_gridbox&task=gridbox.edit&id=<?php echo $page->id; ?>">
<?php
                } else {
?>
                    <span class="not-permitted-wrapper">
<?php
                }
?>
                        <?php echo $introStr; ?>
                        <?php echo $page->title; ?>
<?php
                if ($user->authorise('core.edit', 'com_gridbox.page.'.$page->id)) {
?>
                    </a>
<?php
                } else {
?>
                    </span>
<?php
                }
?>
                </td>
                <td class="hits-cell">
                    <?php echo $page->hits; ?>
                </td>
                <td>
                    <?php echo $page->id; ?>
                </td>
            </tr>
<?php
        }
?>
        </tbody>
    </table>
<?php
} else {
?>
    <div class="dashboard-create-first-page">
        <a href="<?php echo $createUrl.'0&id='; ?>" target="_blank">
            <i class="zmdi zmdi-file"></i>
            <span>+ <?php echo Text::_('CREATE_NEW_PAGE'); ?></span>
        </a>
    </div>
<?php
}
?>
</div>