<?php

use Joomla\CMS\Language\Text;
use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Site\Helper\Dashboard\ReviewsHelper;

$reviews = ReviewsHelper::make()->getItems();
?>
<div class="ba-dashboard-widget widget-sm" data-widget="reviews" data-ind="<?php echo $ind; ?>">
    <table class="table table-striped">
        <thead class="ba-widget-header grid-sorting-handle">
            <tr>
                <th>
                    <span class="ba-widget-header-title">
                        <?php echo $widget->title; ?>
                    </span>
                    <i class="zmdi zmdi-more-vert trigger-context-menu"
                        data-context="widget-settings-context-menu"></i>
                </th>
            </tr>
        </thead>
        <tbody>
<?php
        
        foreach ($reviews as $review) {
            $timestamp = strtotime($review->date);
            if (!empty($review->user_email)) {
                $review->email = $review->user_email;
            }
            $avatar = $review->avatar;
            if (empty($avatar)) {
                $author = GridboxHelper::getAuthor($review->user_id);
                $review->name = $author->title ?? $review->name;
                $avatar = GridboxHelper::getUserAvatar($review->email, 'reviews_enable_gravatar');
            }
            $date = date('Y-m-d', $timestamp);
?>
            <tr>
                <td class="ba-widget-title-td">
                    <div class="ba-widget-image"
                        style="background-image: url(<?php echo str_replace(' ', '%20', $avatar); ?>);">
                    </div>
                    <img src="<?php echo $avatar; ?>" style="display: none !important;"
                        onerror="setGravatarDefault(this);">
                    <div class="ba-widget-content">
                        <span class="ba-widget-title">
                            <span class="ba-widget-title-left">
                                <?php echo $review->name; ?>
                            </span>
                            <span class="ba-widget-title-right">
<?php
                            if ($review->parent == 0) {
?>
                                <span class="review-rating-wrapper">
<?php
                                for ($i = 0; $i < 5; $i++) {
                                    $className = 'zmdi zmdi-star' .
                                        ($i < $review->rating ? ' active' : '');
?>
                                    <i class="<?php echo $className; ?>"></i>
<?php                                                        
                                }
?>
                                </span>
<?php
                            }
?>
                            </span>
                        </span>
                        <span class="ba-widget-text"><?php echo $review->message; ?></span>
                    </div>
                </td>
            </tr>
<?php
        }
?>
        </tbody>
    </table>
    <div class="gridbox-app-item-footer">
        <a href="index.php?option=com_gridbox&view=reviews">
            <i class="zmdi zmdi-ticket-star"></i>
        </a>
    </div>
</div>