<?php

use Balbooa\Component\Gridbox\Site\Helper\DateHelper;
use Joomla\CMS\Language\Text;
use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Site\Helper\Dashboard\SalesHelper;

$currentDate = DateHelper::make();
$d = $currentDate->format('M d, Y');
$w = DateHelper::make(strtotime('-7 days'))->format('M d, Y');
$w .= ' - '.DateHelper::make(strtotime('-1 day'))->format('M d, Y');
$dates = [
    'd' => $d,
    'w' => $w,
    'm' => Text::_('MONTHLY') . ', ' . $currentDate->format('Y'),
    'y' => Text::_('YEARLY'),
    'c' => $d . ' - ' . $d
];
$statistic = SalesHelper::make()->getShopStatistic($currentDate->format('Y-m-d'), 'd');
$statuses = GridboxHelper::getStatuses();
?>
<div class="ba-store-statistic ba-dashboard-widget widget-lg" data-widget="sales"
    data-ind="<?php echo $ind; ?>">
    <div class="ba-store-statistic-header ba-widget-header grid-sorting-handle">
        <div class="ba-store-statistic-header-title-wrapper">
            <span class="ba-store-statistic-header-title ba-widget-header-title">
                <?php echo $widget->title; ?>
            </span>
        </div>
        <div class="ba-store-statistic-header-filter-wrapper">
            <div class="ba-store-statistic-action-wrapper">
                <span class="ba-store-statistic-action" data-action="-">
                    <i class="zmdi zmdi-caret-left"></i>
                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('PREV'); ?></span>
                </span>
                <span class="ba-store-statistic-custom-action">
                    <input type="hidden" class="open-calendar-dialog" data-format="Y-m-d" data-name="0" data-link="1"
                        data-type="range-dates" data-key="from">
                    <i class="zmdi zmdi-calendar-alt"></i>
                </span>
            </div>
            <div class="ba-store-statistic-select-wrapper">
                <div class="ba-custom-select ba-store-statistic-select">
                    <input readonly type="text" value="<?php echo $dates['d']; ?>">
                    <input type="hidden" value="d" data-current="<?php echo $currentDate->format('Y-m-d'); ?>">
                    <ul>
                        <li data-value="d" data-text="<?php echo $dates['d']; ?>">
                            <?php echo Text::_('DAILY'); ?>
                        </li>
                        <li data-value="w" data-text="<?php echo $dates['w']; ?>">
                            <?php echo Text::_('WEEKLY'); ?>
                        </li>
                        <li data-value="m" data-text="<?php echo $dates['m']; ?>">
                            <?php echo Text::_('MONTHLY'); ?>
                        </li>
                        <li data-value="y" data-text="<?php echo $dates['y']; ?>">
                            <?php echo Text::_('YEARLY'); ?>
                        </li>
                        <li data-value="c" data-text="<?php echo $dates['c']; ?>">
                            <?php echo Text::_('CUSTOM'); ?>
                        </li>
                    </ul>
                    <i class="zmdi zmdi-caret-down"></i>
                </div>
            </div>
            <div class="ba-store-statistic-action-wrapper">
                <span class="ba-store-statistic-action" data-action="+">
                    <i class="zmdi zmdi-caret-right"></i>
                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('NEXT'); ?></span>
                </span>
                <span class="ba-store-statistic-custom-action">
                    <input type="hidden" class="open-calendar-dialog" data-format="Y-m-d" data-name="1" data-link="0"
                        data-type="range-dates" data-key="to">
                    <i class="zmdi zmdi-calendar-alt"></i>
                </span>
            </div>
        </div>
        <i class="zmdi zmdi-more-vert trigger-context-menu"
            data-context="widget-settings-context-menu"></i>
    </div>
    <div class="ba-store-statistic-body">
        <div class="row-fluid ba-store-statistic-total-wrapper">
            <div class="span8">
                <div class="ba-store-statistic-count-wrapper" data-type="orders"
                    style="--statistic-count-color: <?php echo $statuses->new->color; ?>;">
                    <span class="ba-store-statistic-count"><?php echo $statistic->counts['orders']; ?></span>
                    <span class="ba-store-statistic-text"><?php echo Text::_('ORDERS'); ?></span>
                </div>
                <div class="ba-store-statistic-count-wrapper" data-type="completed"
                    style="--statistic-count-color: <?php echo $statuses->completed->color; ?>;">
                    <span class="ba-store-statistic-count"><?php echo $statistic->counts['completed']; ?></span>
                    <span class="ba-store-statistic-text"><?php echo Text::_('SALES_STATISTICS'); ?></span>
                </div>
                <div class="ba-store-statistic-count-wrapper" data-type="refunded"
                    style="--statistic-count-color: <?php echo $statuses->refunded->color; ?>;">
                    <span class="ba-store-statistic-count"><?php echo $statistic->counts['refunded']; ?></span>
                    <span class="ba-store-statistic-text"><?php echo Text::_('REFUNDS'); ?></span>
                </div>
            </div>
            <div class="span4">
<?php
                $price = GridboxHelper::preparePrice($statistic->total);
?>
                <div class="ba-store-statistic-total-price">
                    <span class="ba-store-statistic-title"><?php echo Text::_('TOTAL'); ?></span>
                    <span class="ba-store-statistic-price"><?php echo $price; ?></span>
                </div>
            </div>
        </div>
        <div class="row-fluid ba-store-statistic-body-wrapper">
            <div class="span8 ba-statistics-chart-wrapper">
                <span></span>
                <div class="ba-statistics-chart"></div>
            </div>
            <div class="span4 ba-store-statistic-products-wrapper">
                <span class="ba-store-statistic-products-title"><?php echo Text::_('TOP_10'); ?></span>
                <div class="ba-store-statistic-products">
<?php
                foreach ($statistic->products as $product) {
                    $price = GridboxHelper::preparePrice($product->price);
                    $style = empty($product->image) ? '' :
                        'style="background-image: url(' . $product->image . ');"';
                    $product_type = $product->product_type == 'booking' ? 'booking' : 'products';
?>
                    <div class="ba-store-statistic-product"
                        data-type="<?php echo $product_type; ?>">
                        <div class="ba-store-statistic-product-image" <?php echo $style; ?>>
                        <?php
                        if (empty($product->image)) {
?>
                            <i class="<?php echo $product->icon; ?> ba-widget-icon"></i>
<?php
                        }
?>
                        </div>
                        <div class="ba-store-statistic-product-content">
                            <span  class="ba-store-statistic-product-title-wrapper">
                                <span class="ba-store-statistic-product-title">
                                    <?php echo $product->title; ?>
                                </span>
                                <span class="ba-store-statistic-product-description">
<?php
                                if (!empty($product->info)) {
?>
                                    <span class="ba-store-statistic-product-info">
                                        <?php echo $product->info; ?>
                                    </span>
<?php
                                }
?>
                                </span>
                            </span>
                            <span class="ba-store-statistic-product-sales-wrapper">
                                <span class="ba-store-statistic-product-sales">
                                    <span class="ba-store-statistic-product-sales-count">
                                        <?php echo $product->quantity; ?>
                                    </span>
                                    <span class="ba-store-statistic-product-sales-text">
                                        <?php echo Text::_('SALES_STATISTICS') ?>
                                    </span>
                                </span>
                                <span class="ba-store-statistic-price"><?php echo $price; ?></span>
                            </span>
                        </div>
<?php
                    if (!empty($product->link)) {
?>
                        <a href="<?php echo $product->link; ?>" target="_blank"></a>
<?php
                    }
?>
                    </div>
<?php
                }
?>
                </div>
            </div>
        </div>
    </div>
</div>