<?php
/**
 * @package   Gridbox
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

$flags = Uri::root().'components/com_gridbox/assets/images/flags/';
?>

<div id="bulk-author-modal" class="ba-modal-sm modal hide" style="display:none">
    <div class="modal-body">
        <h3><?php echo Text::_('AUTHOR') ?></h3>
        <div class="ba-custom-author-select-wrapper">
            <div class="ba-custom-author-select select-post-author">
                <input readonly type="text" placeholder="<?php echo Text::_('AUTHOR'); ?>">
                <input type="hidden" name="author">
                <ul>
<?php
                    foreach ($this->authors as $author) {
                        if (empty($author->avatar)) {
                            $author->avatar = 'components/com_gridbox/assets/images/default-user.png';
                        }
                        $str = '<li data-value="'.$author->id.'" data-image="'.Uri::root().$author->avatar;
                        $str .= '"><span class="ba-author-avatar" ';
                        $str .= 'style="background-image: url('.Uri::root();
                        $str .= str_replace(' ', '%20', $author->avatar).')"></span>';
                        $str .= $author->title.'</li>';
                        echo $str;
                    }
?>
                </ul>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL') ?>
        </a>
        <a href="#" class="ba-btn-primary apply-bulk-action">
            <?php echo Text::_('JTOOLBAR_APPLY') ?>
        </a>
    </div>
</div>
