<?php
/**
 * @package   Gridbox
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

$flags = Uri::root().'components/com_gridbox/assets/images/flags/';
?>

<div id="bulk-language-modal" class="ba-modal-sm modal hide" style="display:none">
    <div class="modal-body">
        <h3><?php echo Text::_('JFIELD_LANGUAGE_LABEL') ?></h3>
        <div class="ba-custom-select bulk-language-select">
            <input readonly type="text" placeholder="<?php echo Text::_('SELECT'); ?>">
            <input type="hidden">
            <ul>
<?php
                foreach ($this->languages as $key => $language) {
                    $style = $key == '*' ? '' : ' style="--flag-img: url(' . $flags . $key . '.png)"';
?>
                    <li data-value="<?php echo $key; ?>"<?php echo $style; ?>>
                        <?php echo $language; ?>
                    </li>
<?php
                }
?>
            </ul>
            <i class="zmdi zmdi-caret-down"></i>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL') ?>
        </a>
        <a href="#" class="ba-btn-primary apply-bulk-action">
            <?php echo Text::_('JTOOLBAR_APPLY') ?>
        </a>
    </div>
</div>
