<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;
?>
<div id="seo-default-settings-modal" class="ba-modal-md modal hide" style="display:none">
    <div class="modal-body">
        <div class="order-status-tabs-wrapper">
            <ul class="nav nav-tabs uploader-nav">
                <li class="active">
                    <a href="#seo-default-settings-general" data-toggle="tab">
                        <i class="zmdi zmdi-settings"></i>
                        <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('GENERAL'); ?></span>
                    </a>
                </li>
                <li>
                    <a href="#seo-default-settings-sharing" data-toggle="tab">
                        <i class="zmdi zmdi-share"></i>
                        <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('SHARING'); ?></span>
                    </a>
                </li>
<?php
            if (GridboxHelper::checkSystemApp('sitemap')) {
?>
                <li>
                    <a href="#seo-default-settings-sitemap" data-toggle="tab">
                        <i class="zmdi zmdi-device-hub"></i>
                        <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('SITEMAP'); ?></span>
                    </a>
                </li>
<?php
            }
?>
                <li>
                    <a href="#seo-default-settings-schema-markup" data-toggle="tab">
                        <i class="zmdi zmdi-code"></i>
                        <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('SCHEMA_MARKUP'); ?></span>
                    </a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="seo-default-settings-general">
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('BROWSER_PAGE_TITLE'); ?>
                                </label>
                                <div class="select-data-tags input-action-icon" data-template="page-data-tags-template">
                                    <i class="zmdi zmdi-playlist-plus"></i>
                                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DATA_TAGS'); ?></span>
                                </div>
                            </div>
                            <input type="hidden" data-key="id">
                            <input type="hidden" data-key="item_id">
                            <input type="hidden" data-key="item_type">
                            <input type="text" data-key="meta_title" placeholder="<?php echo Text::_('BROWSER_PAGE_TITLE'); ?>">
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('JFIELD_META_DESCRIPTION_LABEL'); ?>
                                </label>
                                <div class="select-data-tags input-action-icon" data-template="page-data-tags-template">
                                    <i class="zmdi zmdi-playlist-plus"></i>
                                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DATA_TAGS'); ?></span>
                                </div>
                            </div>
                            <textarea data-key="meta_description" placeholder="<?php echo Text::_('JFIELD_META_DESCRIPTION_LABEL'); ?>"></textarea>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="seo-default-settings-sharing">
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('IMAGE'); ?>
                                </label>
                                <div class="select-data-tags input-action-icon" data-template="page-data-tags-template">
                                    <i class="zmdi zmdi-playlist-plus"></i>
                                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DATA_TAGS'); ?></span>
                                </div>
                            </div>
                            <input type="text" data-key="share_image" placeholder="<?php echo Text::_('IMAGE'); ?>">
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('JGLOBAL_TITLE'); ?>
                                </label>
                                <div class="select-data-tags input-action-icon" data-template="page-data-tags-template">
                                    <i class="zmdi zmdi-playlist-plus"></i>
                                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DATA_TAGS'); ?></span>
                                </div>
                            </div>
                            <input type="text" data-key="share_title" placeholder="<?php echo Text::_('JGLOBAL_TITLE'); ?>">
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('DESCRIPTION'); ?>
                                </label>
                                <div class="select-data-tags input-action-icon" data-template="page-data-tags-template">
                                    <i class="zmdi zmdi-playlist-plus"></i>
                                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DATA_TAGS'); ?></span>
                                </div>
                            </div>
                            <textarea data-key="share_description" placeholder="<?php echo Text::_('DESCRIPTION'); ?>"></textarea>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="seo-default-settings-sitemap">
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('INCLUDE_ITEM'); ?>
                                </label>
                            </div>
                            <div class="ba-custom-select">
                                <input readonly="" onfocus="this.blur()" type="text">
                                <input type="hidden" data-key="sitemap_include">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="1"><?php echo Text::_('INCLUDE'); ?></li>
                                    <li data-value="0"><?php echo Text::_('EXCLUDE'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    Changefreq
                                </label>
                            </div>
                            <div class="ba-custom-select ba-fixed-custom-select">
                                <input readonly="" onfocus="this.blur()" type="text">
                                <input type="hidden" data-key="changefreq">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="always"><?php echo Text::_('ALWAYS'); ?></li>
                                    <li data-value="hourly"><?php echo Text::_('HOURLY'); ?></li>
                                    <li data-value="daily"><?php echo Text::_('DAILY'); ?></li>
                                    <li data-value="weekly"><?php echo Text::_('WEEKLY'); ?></li>
                                    <li data-value="monthly"><?php echo Text::_('MONTHLY'); ?></li>
                                    <li data-value="yearly"><?php echo Text::_('YEARLY'); ?></li>
                                    <li data-value="never"><?php echo Text::_('NEVER'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ba-options-group">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    Priority
                                </label>
                            </div>
                            <div class="ba-custom-select ba-fixed-custom-select">
                                <input readonly="" onfocus="this.blur()" type="text">
                                <input type="hidden" data-key="priority">
                                <i class="zmdi zmdi-caret-down"></i>
                                <ul>
                                    <li data-value="0">0</li>
                                    <li data-value="0.1">0.1</li>
                                    <li data-value="0.2">0.2</li>
                                    <li data-value="0.3">0.3</li>
                                    <li data-value="0.4">0.4</li>
                                    <li data-value="0.5">0.5</li>
                                    <li data-value="0.6">0.6</li>
                                    <li data-value="0.7">0.7</li>
                                    <li data-value="0.8">0.8</li>
                                    <li data-value="0.9">0.9</li>
                                    <li data-value="1">1</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="seo-default-settings-schema-markup">
                    <div class="ba-options-group schema-markup-wrapper">
                        <div class="ba-group-element">
                            <div class="schema-markup-label">
                                <label>
                                    <?php echo Text::_('JSON_LD_SCHEMA_MARKUP'); ?>
                                </label>
                                <div class="select-data-tags input-action-icon" data-template="page-data-tags-template">
                                    <i class="zmdi zmdi-playlist-plus"></i>
                                    <span class="ba-tooltip ba-top ba-hide-element"><?php echo Text::_('DATA_TAGS'); ?></span>
                                </div>
                            </div>
                            <textarea data-key="schema_markup"></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL') ?>
        </a>
<?php
    if ($user->authorise('core.edit', 'com_gridbox')) {
?>
        <a href="#" class="ba-btn-primary apply-seo-default-settings active-button">
            <?php echo Text::_('JTOOLBAR_APPLY') ?>
        </a>
<?php
    }
?>
    </div>
</div>
<div class="ba-context-menu options-context-menu" data-source="gridbox-options" style="display: none">
    <span class="export-gridbox">
        <i class="zmdi zmdi-download "></i>
        <span class="ba-context-menu-title">
            <?php echo Text::_('EXPORT'); ?>
        </span>
    </span>
    <span class="import-gridbox">
        <i class="zmdi zmdi-upload"></i>
        <span class="ba-context-menu-title">
            <?php echo Text::_('IMPORT'); ?>
        </span>
    </span>
    <span class="import-joomla-content">
        <i class="zmdi zmdi-inbox"></i>
        <span class="ba-context-menu-title">
            <?php echo Text::_('IMPORT_JOOMLA_CONTENT'); ?>
        </span>
    </span>
    <span class="context-menu-item-link ba-group-element">
        <a href="index.php?option=com_config&view=component&component=com_gridbox"
            class="default-action">
            <i class="zmdi zmdi-accounts"></i>
            <span class="ba-context-menu-title">
                <?php echo Text::_('JCONFIG_PERMISSIONS_LABEL'); ?>
            </span>
        </a>
    </span>
    <span class="context-menu-item-link ba-group-element">
        <a href="index.php?option=com_gridbox&view=integrations" class="default-action">
            <i class="zmdi zmdi-cloud-done"></i>
            <span class="ba-context-menu-title">
                <?php echo Text::_('INTEGRATIONS'); ?>
            </span>
        </a>
    </span>
</div>
<div id="import-joomla-content-modal" class="ba-modal-md modal hide" style="display:none">
    <div class="modal-body">
        <div class="ba-modal-header">
            <h3><?php echo Text::_('SELECT_APP_TO_IMPORT_ARTICLES'); ?></h3>
            <i data-dismiss="modal" class="zmdi zmdi-close"></i>
        </div>
        <div class="availible-folders">
            <ul class="root-list">
                
            </ul>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL') ?>
        </a>
        <a href="#" class="ba-btn-primary apply-import-joomla-content">
            <?php echo Text::_('IMPORT') ?>
        </a>
    </div>
</div>
<div id="import-dialog" class="ba-modal-sm modal hide" style="display:none">
    <div class="modal-header">
        <h3><?php echo Text::_('IMPORT'); ?></h3>
        <label class="ba-help-icon">
            <i class="zmdi zmdi-help"></i>
            <span class="ba-tooltip ba-help ba-hide-element">
                <?php echo Text::_('IMPORT_PAGES_THEMES_TOOLTIP'); ?> 
            </span>
        </label>
    </div>
    <div class="modal-body">
        <div class="ba-input-lg">
            <input id="theme-import-trigger" class="theme-import-trigger" readonly
                type="text" placeholder="<?php echo Text::_('SELECT'); ?>">
            <i class="zmdi zmdi-attachment-alt theme-import-trigger"></i>
            <input type="file" id="theme-import-file" name="ba-files[]" style="display: none;">
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal">
            <?php echo Text::_('CANCEL') ?>
        </a>
        <a href="#" class="ba-btn-primary apply-import">
            <?php echo Text::_('INSTALL') ?>
        </a>
    </div>
</div>