<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Balbooa\Component\Gridbox\Site\Helper\FileHelper;
use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\Helper\SidebarHelper;

defined('_JEXEC') or die;

$user = Factory::getUser();
$installedBlog = GridboxHelper::checkInstalledBlog();
$installedStore = GridboxHelper::checkInstalledBlog('products');
$installedBooking = GridboxHelper::checkInstalledBlog('booking');
$installedComments = GridboxHelper::checkSystemApp('comments');
$commentsCount = GridboxHelper::getUnreadCount('#__gridbox_comments');
$installedReviews = GridboxHelper::checkSystemApp('reviews');
$reviewsCount = GridboxHelper::getUnreadCount('#__gridbox_reviews');
$ordersCount = GridboxHelper::getUnreadCount('#__gridbox_store_orders', 'published = 1');
$bookingCount = GridboxHelper::getUnreadCount('#__gridbox_store_bookings', isBooking: true);
$emptySysActions = ($installedBlog || $installedComments || $installedReviews);
$hasSubscriptions = GridboxHelper::checkSubscriptions();
$sidebarApps = GridboxHelper::getGridboxAppsList();
$access = GridboxHelper::getAccess();
$sidebar = SidebarHelper::make()::getSidebar();

?>
<script src="<?php echo Uri::root(); ?>administrator/components/com_gridbox/assets/js/sortable.js"></script>
<script src="<?php echo Uri::root() ?>components/com_gridbox/libraries/bootstrap/bootstrap.js?<?php echo $this->about->version; ?>"
    ></script>
<script>
var JUri = '<?php echo Uri::root(); ?>',
    IMAGE_PATH = '<?php echo FileHelper::getImagePath(); ?>';
app.navigation = <?php echo json_encode($sidebar); ?>;
<?php echo GridboxHelper::getGridboxLanguage(); ?>
</script>
<div class="ba-sidebar">
    <div class="ba-sidebar-header">
        <span class="toggle-sidebar">
            <i class="zmdi zmdi-format-clear-all"></i>
        </span>
    </div>
    <div class="ba-sidebar-body">
        <ul class="general-actions">
<?php
            echo SidebarHelper::renderItem(
                'dashboard',
                'index.php?option=com_gridbox',
                'zmdi zmdi-home',
                Text::_('DASHBOARD'),
                settings: false
            );

            $html = '';
            foreach ($sidebarApps as $app) {
                $str = '';
                $isGroup = $app->type == 'group';
                if ($isGroup) {
                    $childs = GridboxHelper::getGridboxAppsList($app->id);
                    foreach ($childs as $child) {
                        $str .= SidebarHelper::renderItem(
                            (string) $child->id,
                            GridboxHelper::getUrl($child),
                            GridboxHelper::getIcon($child),
                            $child->title
                        );
                    }
                }
                $html .= SidebarHelper::renderItem(
                    ($isGroup ? 'group-' : '') . $app->id,
                    ($isGroup ? '': GridboxHelper::getUrl($app)),
                    ($isGroup ? '': GridboxHelper::getIcon($app)),
                    $app->title,
                    children: $str
                );
            }
            echo SidebarHelper::renderItem(
                'appslist',
                'index.php?option=com_gridbox&view=appslist',
                'zmdi zmdi-widgets',
                Text::_('APPS'),
                'app-list sidebar-context-parent',
                children: $html,
                context: 'apps-list-context-menu',
            );
?>
        </ul>
        
        <ul class="ba-system-actions<?php echo $emptySysActions ? '' : ' empty-system-actions'; ?>">
<?php
        if ($installedStore || $installedBooking) {
            $str = '';
            $html = $ordersCount == 0 ? '' :
                '<span class="unread-comments-count" data-type="orders">'
                . $ordersCount . '</span>';
            $str .= SidebarHelper::renderItem(
                'orders',
                'index.php?option=com_gridbox&view=orders',
                'zmdi zmdi-shopping-cart',
                Text::_('ORDERS'),
                html: $html
            );
            if ($installedBooking) {
                $html = $bookingCount == 0 ? '' :
                    '<span class="unread-comments-count" data-type="booking">'
                    . $bookingCount . '</span>';
                $str .= SidebarHelper::renderItem(
                    'bookingcalendar',
                    'index.php?option=com_gridbox&view=bookingcalendar',
                    'zmdi zmdi-calendar-note',
                    Text::_('CALENDAR'),
                    html: $html
                );
            }
            if ($hasSubscriptions) {
                $str .= SidebarHelper::renderItem(
                    'subscriptions',
                    'index.php?option=com_gridbox&view=subscriptions',
                    'zmdi zmdi-time-restore',
                    Text::_('SUBSCRIPTIONS')
                );
            }
            $str .= SidebarHelper::renderItem(
                'paymentmethods',
                'index.php?option=com_gridbox&view=paymentmethods',
                'zmdi zmdi-card',
                Text::_('PAYMENT_METHODS')
            );
            if ($installedStore) {
                $str .= SidebarHelper::renderItem(
                    'shipping',
                    'index.php?option=com_gridbox&view=shipping',
                    'zmdi zmdi-truck',
                    Text::_('SHIPPING')
                );
            }
            $str .= SidebarHelper::renderItem(
                'promocodes',
                'index.php?option=com_gridbox&view=promocodes',
                'zmdi zmdi-card-giftcard',
                Text::_('PROMO_CODES')
            );
            $str .= SidebarHelper::renderItem(
                'sales',
                'index.php?option=com_gridbox&view=sales',
                'zmdi zmdi-bookmark',
                Text::_('DISCOUNTS')
            );
            $str .= SidebarHelper::renderItem(
                'productoptions',
                'index.php?option=com_gridbox&view=productoptions',
                'zmdi zmdi-invert-colors',
                Text::_('PRODUCT_OPTIONS')
            );
            $str .= SidebarHelper::renderItem(
                'storesettings',
                'index.php?option=com_gridbox&view=storesettings',
                'zmdi zmdi-settings',
                Text::_('SETTINGS')
            );
            $html = $ordersCount == 0 && $bookingCount == 0 ? '' :
                '<span class="unread-comments-count" data-type="orders">'.
                $ordersCount + $bookingCount . '</span>';
            echo SidebarHelper::renderItem(
                'store',
                'index.php?option=com_gridbox&view=orders',
                'zmdi zmdi-shopping-cart',
                Text::_('STORE'),
                'gridbox-store sidebar-context-parent',
                html: $html,
                children: $str,
                context: 'store-context-menu'
            );
        }
        if ($installedComments) {
            $html = $commentsCount == 0 ? '' :
                '<span class="unread-comments-count" data-type="comments">'
                . $commentsCount . '</span>';
            echo SidebarHelper::renderItem(
                'comments',
                'index.php?option=com_gridbox&view=comments',
                'zmdi zmdi-comment-more',
                Text::_('COMMENTS'),
                html: $html
            );
        }
        if ($installedReviews) {
            $html = $reviewsCount == 0 ? '' :
                '<span class="unread-comments-count" data-type="reviews">'
                . $reviewsCount . '</span>';
            echo SidebarHelper::renderItem(
                'reviews',
                'index.php?option=com_gridbox&view=reviews',
                'zmdi zmdi-ticket-star',
                Text::_('REVIEWS'),
                html: $html
            );
        }
        if ($installedBlog > 0) {
            echo SidebarHelper::renderItem(
                'authors',
                'index.php?option=com_gridbox&view=authors',
                'zmdi zmdi-account-circle',
                Text::_('AUTHORS')
            );
            echo SidebarHelper::renderItem(
                'tags',
                'index.php?option=com_gridbox&view=tags',
                'zmdi zmdi-label',
                Text::_('TAGS')
            );
        }
?>
        </ul>
<?php
        if ($user->authorise('core.tools', 'com_gridbox')) {
?>
        <ul class="developer-tools-actions">
<?php
            echo SidebarHelper::renderItem(
                'themes',
                'index.php?option=com_gridbox&view=themes',
                'zmdi zmdi-format-color-fill',
                Text::_('THEMES'),
                settings: false
            );
            echo SidebarHelper::renderItem(
                'system',
                'index.php?option=com_gridbox&view=system',
                'zmdi zmdi-alert-polygon',
                Text::_('SYSTEM_PAGES'),
                settings: false
            );
            echo SidebarHelper::renderItem(
                'trashed',
                'index.php?option=com_gridbox&view=trashed',
                'zmdi zmdi-delete',
                Text::_('TRASHED_ITEMS'),
                settings: false
            );
            echo SidebarHelper::renderItem(
                key: 'options',
                icon: 'zmdi zmdi-settings',
                title: Text::_('OPTIONS'),
                classname: 'sidebar-context-parent',
                settings: false,
                context: 'options-context-menu'
            );
?>
        </ul>
<?php
        }
?>
        <ul class="custom-sidebar-items">
<?php
        echo SidebarHelper::getCustomTree();

        if ($user->authorise('core.tools', 'com_gridbox')) {
?>
            <li class="add-custom-sidebar-items">
                <span>
                    <i class="zmdi zmdi-plus-circle"></i>
                    <span class="sidebar-title">
                        <?php echo Text::_('ADD_NEW_ITEM'); ?>
                    </span>
                </span>
            </li>
<?php
        }
?>
        </ul>
    </div>
    <div class="ba-sidebar-footer">
        <?php $route = 'index.php?option=com_login&task=logout&amp;' . Session::getFormToken() . '=1'; ?>
        <a class="gridbox-logout-link" href="<?php echo Route::_($route); ?>">
            <i class="zmdi zmdi-power"></i>
            <span class="sidebar-title"><?php echo Text::_('JLOGOUT'); ?></span>
            <span class="ba-tooltip ba-right ba-hide-element"><?php echo Text::_('JLOGOUT'); ?></span>
        </a>
<?php
        if ($user->authorise('core.tools', 'com_gridbox')) {
?>
        <span class="edit-navigation">
            <i class="zmdi zmdi-tune"></i>
            <span class="sidebar-title"><?php echo Text::_('EDIT_NAVIGATION'); ?></span>
            <label class="ba-checkbox toggle-btn toggle-btn-blue">
                <input type="checkbox">
                <span></span>
            </label>
        </span>
<?php
        }
?>
    </div>
</div>
<div id="edit-navigation-link-modal" class="ba-modal-sm modal ba-modal-dialog hide" style="display: none;">
    <div class="modal-header">
        <h3 class="ba-modal-header"><?php echo Text::_('SETTINGS'); ?></h3>
    </div>
    <div class="modal-body">
        <div class="ba-input-lg">
            <input type="text" class="reset-input-margin" required
                data-option="title" placeholder="<?php echo Text::_('JGLOBAL_TITLE'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-input-lg">
            <input type="text" class="reset-input-margin"
                data-option="link" placeholder="<?php echo Text::_('LINK'); ?>">
            <span class="focus-underline"></span>
        </div>
        <div class="ba-custom-select ba-custom-select-lg link-target-select">
            <input type="text" readonly class="reset-input-margin">
            <input type="hidden" data-option="target">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <li data-value="_self"><?php echo Text::_('SAME_WINDOW') ?></li>
                <li data-value="_blank"><?php echo Text::_('NEW_WINDOW') ?></li>
            </ul>
        </div>
        <div class="ba-input-lg">
            <input type="text" class="input-with-icon reset-input-margin" readonly onfocus="this.blur()"
                data-option="icon" placeholder="<?php echo Text::_('ICON'); ?>">
            <i class="zmdi zmdi-attachment-alt"></i>
            <div class="reset disabled-reset reset-share-image">
                <i class="zmdi zmdi-close"></i>
            </div>
        </div>
        <div class="ba-custom-select ba-custom-select-lg navigation-access-select">
            <input type="text" class="reset-input-margin" readonly>
            <input type="hidden" data-option="access">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
<?php
                foreach ($access as $key => $item) {
?>
                    <li data-value="<?php echo $key; ?>"><?php echo $item ?></li>
<?php
                }
?>
            </ul>
        </div>
        <div class="ba-custom-select ba-custom-select-lg navigation-parent-select">
            <input type="text" readonly>
            <input type="hidden" data-option="parent">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
                <li data-value=""><?php echo Text::_('MENU_ITEM_ROOT') ?></li>
            </ul>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal"><?php echo Text::_('CANCEL') ?></a>
        <a href="#" class="ba-btn-primary apply-navigation-link active-button">
            <?php echo Text::_('JTOOLBAR_APPLY') ?>
        </a>
    </div>
</div>
<div id="icon-upload-dialog" class="ba-modal-lg modal hide" style="display: none;">
    <div class="modal-header">
        <span class="ba-dialog-title"><?php echo Text::_('LIBRARY_ICONS'); ?></span>
        <div class="modal-header-icon">
            <i class="zmdi zmdi-fullscreen media-fullscrean"></i>
            <i class="zmdi zmdi-close" data-dismiss="modal"></i>
        </div>
    </div>
    <div class="modal-body">
        <iframe src="javascript:''"></iframe>
    </div>
</div>
<div id="navigation-settings-modal" class="ba-modal-sm modal ba-modal-dialog hide" style="display: none;">
    <div class="modal-header">
        <h3 class="ba-modal-header"><?php echo Text::_('SETTINGS'); ?></h3>
    </div>
    <div class="modal-body">
        <div class="ba-custom-select ba-custom-select-lg">
            <input type="text" readonly>
            <input type="hidden" data-option="access">
            <i class="zmdi zmdi-caret-down"></i>
            <ul>
<?php
                foreach ($access as $key => $item) {
?>
                    <li data-value="<?php echo $key; ?>"><?php echo $item ?></li>
<?php
                }
?>
            </ul>
        </div>
    </div>
    <div class="modal-footer">
        <a href="#" class="ba-btn" data-dismiss="modal"><?php echo Text::_('CANCEL') ?></a>
        <a href="#" class="ba-btn-primary apply-navigation-settings active-button">
            <?php echo Text::_('JTOOLBAR_APPLY') ?>
        </a>
    </div>
</div>

<div class="ba-context-menu store-context-menu" data-source="gridbox-store" style="display: none">
<?php
    if (SidebarHelper::checkAccess(SidebarHelper::getAccess('orders'))) {
?>
    <span class="context-menu-item-link">
        <a href="index.php?option=com_gridbox&view=orders" class="default-action">
            <i class="zmdi zmdi-shopping-cart"></i>
            <span class="ba-context-menu-title">
                <?php echo Text::_('ORDERS'); ?>
            </span>
<?php
        if ($ordersCount > 0) {
?>
            <span class="unread-comments-count" data-type="orders"><?php echo $ordersCount; ?></span>
<?php
        }
?>            
        </a>
    </span>
<?php
    }
?>
<?php
if ($installedBooking && SidebarHelper::checkAccess(SidebarHelper::getAccess('bookingcalendar'))) {
?>
    <span class="context-menu-item-link">
        <a href="index.php?option=com_gridbox&view=bookingcalendar" class="default-action">
            <i class="zmdi zmdi-calendar-note"></i>
            <span class="ba-context-menu-title">
                <?php echo Text::_('CALENDAR'); ?>
            </span>
<?php
        if ($bookingCount > 0) {
?>
            <span class="unread-comments-count" data-type="booking"><?php echo $bookingCount; ?></span>
<?php
        }
?> 
        </a>
    </span>
<?php
}
if ($hasSubscriptions && SidebarHelper::checkAccess(SidebarHelper::getAccess('subscriptions'))) {
?>
    <span class="context-menu-item-link">
        <a href="index.php?option=com_gridbox&view=subscriptions" class="default-action">
            <i class="zmdi zmdi-time-restore"></i>
            <span class="ba-context-menu-title">
                <?php echo Text::_('SUBSCRIPTIONS'); ?>
            </span>
        </a>
    </span>
<?php
}
?>
<?php
    if (SidebarHelper::checkAccess(SidebarHelper::getAccess('paymentmethods'))) {
?>
    <span class="context-menu-item-link">
        <a href="index.php?option=com_gridbox&view=paymentmethods" class="default-action">
            <i class="zmdi zmdi-card"></i>
            <span class="ba-context-menu-title">
                <?php echo Text::_('PAYMENT_METHODS'); ?>
            </span>
        </a>
    </span>
<?php
    }
?>
    
<?php
if ($installedStore && SidebarHelper::checkAccess(SidebarHelper::getAccess('shipping'))) {
?>
    <span class="context-menu-item-link">
        <a href="index.php?option=com_gridbox&view=shipping" class="default-action">
            <i class="zmdi zmdi-truck"></i>
            <span class="ba-context-menu-title">
                <?php echo Text::_('SHIPPING'); ?>
            </span>
        </a>
    </span>
<?php
}
?>
<?php
    if (SidebarHelper::checkAccess(SidebarHelper::getAccess('promocodes'))) {
?>
    <span class="context-menu-item-link">
        <a href="index.php?option=com_gridbox&view=promocodes" class="default-action">
            <i class="zmdi zmdi-card-giftcard"></i>
            <span class="ba-context-menu-title">
                <?php echo Text::_('PROMO_CODES'); ?>
            </span>
        </a>
    </span>
<?php
    }
?>
    
    <?php
    if (SidebarHelper::checkAccess(SidebarHelper::getAccess('sales'))) {
?>
    <span class="context-menu-item-link">
        <a href="index.php?option=com_gridbox&view=sales" class="default-action">
            <i class="zmdi zmdi-bookmark"></i>
            <span class="ba-context-menu-title">
                <?php echo Text::_('DISCOUNTS'); ?>
            </span>
        </a>
    </span>
<?php
    }
?>
    
    <?php
    if (SidebarHelper::checkAccess(SidebarHelper::getAccess('productoptions'))) {
?>
    <span class="context-menu-item-link">
        <a href="index.php?option=com_gridbox&view=productoptions" class="default-action">
            <i class="zmdi zmdi-invert-colors"></i>
            <span class="ba-context-menu-title">
                <?php echo Text::_('PRODUCT_OPTIONS'); ?>
            </span>
        </a>
    </span>
<?php
    }
?>
    <?php
    if (SidebarHelper::checkAccess(SidebarHelper::getAccess('storesettings'))) {
?>
    <span class="context-menu-item-link ba-group-element">
        <a href="index.php?option=com_gridbox&view=storesettings" class="default-action">
            <i class="zmdi zmdi-settings"></i>
            <span class="ba-context-menu-title">
                <?php echo Text::_('SETTINGS'); ?>
            </span>
        </a>
    </span>
<?php
    }
?>
</div>
<?php
echo SidebarHelper::getCustomContextMenus();

include SidebarHelper::$path . '/apps-list-context-menu.php';