<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\Helper\SidebarHelper;

?>

<div class="ba-context-menu apps-list-context-menu" data-source="app-list" style="display: none">
<?php
foreach ($sidebarApps as $key => $app) {
    $isGroup = $app->type == 'group';
    $ind = ($isGroup ? 'group-' : '') . $app->id;
    if (!SidebarHelper::checkAccess(SidebarHelper::getAccess($ind))) {
        continue;
    }
    $attr = 'class="' . (!$isGroup ? 'default-action'
        : 'sidebar-context-parent apps-group-' . $app->id) . '" ' .
        (!$isGroup ? '' : ' data-context="apps-list-context-menu-'
            . $app->id . '"');
?>
    <span class="context-menu-item-link" data-id="<?php echo $app->id; ?>">
        <a href="<?php echo GridboxHelper::getUrl($app); ?>" <?php echo $attr; ?>>
            <i class="<?php echo GridboxHelper::getIcon($app); ?>"></i>
            <span>
                <?php echo $app->title; ?>
            </span>
<?php
        if ($isGroup) {
?>
            <i class="zmdi zmdi-caret-right"></i>
<?php
        }
?>
        </a>
    </span>
<?php
}
?>
</div>
<?php
foreach ($sidebarApps as $key => $app) {
    if ($app->type != 'group') {
        continue;
    }
?>
<div class="ba-context-menu apps-group-childs apps-list-context-menu-<?php echo $app->id ?>"
    data-source="apps-group-<?php echo $app->id ?>" style="display: none">
<?php
    $childs = GridboxHelper::getGridboxAppsList($app->id);
    foreach ($childs as $child) {
        $ind = (string) $child->id;
        if (!SidebarHelper::checkAccess(SidebarHelper::getAccess($ind))) {
            continue;
        }
?>
    <span class="context-menu-item-link" data-id="<?php echo $child->id; ?>">
        <a href="<?php echo GridboxHelper::getUrl($child); ?>" class="default-action">
            <i class="<?php echo GridboxHelper::getIcon($child); ?>"></i>
            <span>
                <?php echo $child->title; ?>
            </span>
        </a>
    </span>
<?php
    }
?>
</div>
<?php
}
?>