<?php
/**
 * @package   Gridbox
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */
ob_start();

foreach (self::$customItems as $key => $items) {
    if ($key == 'root') {
        continue;
    }
?>
<div class="ba-context-menu apps-group-childs apps-group-<?php echo $key ?>"
    data-source="apps-group-<?php echo $key ?>" style="display: none">
<?php
    foreach ($items as $item) {
        $hasChildren = isset(self::$customItems->{$item->key});
        $attr = 'class="default-action ' .
            (!$hasChildren ? '' :
                'sidebar-context-parent apps-group-'.$item->key) .
            '" ' . (!$hasChildren ? '' :
                'data-context="apps-group-' . $item->key . '"');
?>
    <span class="context-menu-item-link">
        <a href="<?php echo $item->link; ?>" <?php echo $attr; ?>>
            <i class="<?php echo !empty($item->icon) ? $item->icon : 'zmdi zmdi-folder'; ?>"></i>
            <span>
                <?php echo $item->title; ?>
            </span>
<?php
        if ($hasChildren) {
?>
            <i class="zmdi zmdi-caret-right"></i>
<?php
        }
?>
        </a>
    </span>
<?php
    }
?>
</div>
<?php
}

$html = ob_get_clean();