export default class PromoCodeDialog
{
    static dialog = null;

    static render()
    {
        let div = document.createElement('div');
        div.style.display = 'none';
        div.className = 'ba-modal-sm modal hide';
        div.innerHTML = `
            <div class="modal-body">
                <h3 class="ba-modal-title">${app._('ENTER_PROMO_CODE')}</h3>
                <div class="ba-input-lg">
                    <input type="text" placeholder="${app._('ENTER_PROMO_CODE')}">
                    <span class="focus-underline"></span>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="ba-btn" data-dismiss="modal">${app._('CANCEL')}</a>
                <a href="#" class="ba-btn-primary active-button">${app._('APPLY')}</a>
            </div>`;
        document.body.append(div);
        this.dialog = $g(div);
        this.input = this.dialog.find('input');
        this.setEvents();
    }

    static setEvents()
    {
        this.dialog.on('hide', this.hide.bind(this));
        if (themeData.page.view == 'gridbox') {
            return;
        }
        this.dialog.find('.ba-btn-primary').on('click', this.submit.bind(this));
    }

    static submit(event)
    {
        event.preventDefault();
        let promo = this.input.val();
        this.apply(promo);
    }

    static remove()
    {
        if (themeData.page.view == 'gridbox') {
            return false;
        }
        this.apply();
    }

    static apply(promo = '')
    {
        app.fetch(JUri+'index.php?option=com_gridbox&view=editor&task=store.applyPromoCode', {
            promo: promo
        }).then(html => {
            if (html == 'invalid') {
                app.showNotice(app._('COUPON_CODE_INVALID'), 'ba-alert');
                return
            }
            if (app.storeCart) {
                app.storeCart.updateCartTotal();
            }
            document.dispatchEvent(new CustomEvent('PromoCodeUpdated'))
            if (this.dialog && this.dialog.hasClass('in')) {
                this.dialog.modal('hide');
            }
        });
    }

    static hide()
    {
        app.AccessibilityHelper.releaseTrap(this.dialog[0]);
    }

    static show($this)
    {
        if (!this.dialog) {
            this.render();
        }
        this.input.val($this.dataset.code);
        this.dialog.modal();
        app.AccessibilityHelper.trapFocus(this.dialog[0], 350);
    }
}