/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/


!function ($) {

    class weather {
        constructor(element, options, view) {
            this.item = $(element);
            this.options = options;
            this.view = view;
        }
        init() {
            var $this = this;
            app.fetch(JUri + "index.php?option=com_gridbox&task=editor.renderWeather", {
                weather: JSON.stringify($this.options),
                view: themeData.page.view
            }).then((text) => {
                if (!text) {
                    return;
                }
                $this.item.html(text);
                if (themeData.page.view == 'gridbox') {
                    return;
                }
                if (!$this.view.wind) {
                    $this.item.find('.weather-info .wind').remove();
                }
                if (!$this.view.humidity) {
                    $this.item.find('.weather-info .humidity').remove();
                }
                if (!$this.view.pressure) {
                    $this.item.find('.weather-info .pressure').remove();
                }
                if (!$this.view.pressure && !$this.view.humidity && !$this.view.wind) {
                    $this.item.find('.weather-info').remove();
                }
                $this.item.find('.forecast').each(function (i) {
                    if (i >= $this.view.forecast) {
                        this.remove();
                    }
                });
            })
        }
    }
    
    
    $.fn.weather = function(option, view) {
        return this.each(function() {
            var $this = $(this),
                data = $this.data('weather'),
                options = $.extend({}, $.fn.weather.defaults, typeof option == 'object' && option);
            if (data) {
                $this.removeData();
            }
            $this.data('weather', (data = new weather(this, options, view)));
            data.init();
        });
    }
    
    $.fn.weather.defaults = {
        location : 'New York, NY, United States',
        unit : 'c'
    }
    $.fn.weather.Constructor = weather;
}(window.$g ? window.$g : window.jQuery);