<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\MVC\Controller\FormController;

class AccountController extends FormController
{
    /**
     * @return Balbooa\Component\Gridbox\Site\Model
     */
    public function getModel($name = 'Account', $prefix = 'Site', $config = ['ignore_request' => false])
	{
		return parent::getModel($name, $prefix, $config);
	}

    public function uploadProfileImage()
    {
        $input = Factory::getApplication()->input;
        $file = $input->files->get('file', [], 'array');
        $model = $this->getModel();
        $obj = $model->uploadProfileImage($file);
        $str = json_encode($obj);
        echo $str;
        exit();
    }

    public function deleteSubmitted()
    {
        $id = $this->input->get('id', 0, 'int');
        $model = $this->getModel();
        $model->deleteSubmitted($id);
        exit;
    }

    public function getOrder()
    {
        $id = $this->input->get('id', 0, 'int');
        $model = $this->getModel();
        $order = $model->getOrder($id);
        $order->date = HTMLHelper::date($order->date, GridboxHelper::$dateFormat);
        $str = json_encode($order);
        echo $str;exit();
    }

    public function saveCustomerInfo()
    {
        $data = $this->input->post->getArray([]);
        $model = $this->getModel();
        $model->saveCustomerInfo($data);
        exit();
    }

    public function socialLogin()
    {
        $data = $this->input->post->getArray([]);
        $model = $this->getModel();
        $model->socialLogin($data);
        exit;
    }

    public function remindUsername()
    {
        $email = $this->input->post->get('email', '', 'string');
        $model = $this->getModel();
        $model->remindUsername($email);
        exit;
    }

    public function remindPassword()
    {
        $email = $this->input->post->get('email', '', 'string');
        $model = $this->getModel();
        $model->remindPassword($email);
        exit;
    }

    public function requestPassword()
    {
        $data = $this->input->post->getArray([]);
        $model = $this->getModel();
        $model->requestPassword($data);
        exit;
    }

    public function resetPassword()
    {
        $data = $this->input->post->getArray([]);
        $model = $this->getModel();
        $model->resetPassword($data);
        exit;
    }
}