<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Site\Helper\DateHelper;
use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;

class CalendarController extends FormController
{
    public function getSingleSlots(): never
    {
        $product_id = $this->input->get('id', 0, 'int');
        $date = $this->input->get('date', '', 'string');
        $options = GridboxHelper::$storeHelper->getProductData($product_id)->booking;
        $booking = GridboxHelper::getBooking();
        $dateObject = DateHelper::make($date);
        $times = $booking->getSingleSlots($options, $dateObject, $product_id);
        $str = json_encode($times);
        echo $str;
        exit;
    }

    public function render(): never
    {
        $year = $this->input->get('year', '0', 'string');
        $month = $this->input->get('month', '0', 'string');
        $format = $this->input->get('date_format', 'Y-m-d', 'raw');
        $product_id = $this->input->get('product_id', 0, 'int');
        $footer = $this->input->get('footer', 0, 'int');
        $multiple = $this->input->get('multiple', 0, 'int');
        if (empty($format)) {
            $format = 'Y-m-d';
        }
        if (strlen($month) == 1) {
            $month = '0' . $month;
        }
        $date = DateHelper::make($year.'-'.$month.'-01');
        $str = $this->getCalendar($date, $month, $year, 1, $format, $product_id, $footer, $multiple);
        echo $str;
        exit;
    }

    public function getCalendar(
        object $dateObject,
        string $month,
        string $year,
        int $start,
        string $format,
        int $product_id,
        int $footer,
        int $multiple
    ): string {
        $end = $start + 6;
        $localisedDays= [
            Text::_('SUN'), Text::_('MON'), Text::_('TUE'), Text::_('WED'),
            Text::_('THU'), Text::_('FRI'), Text::_('SAT'), Text::_('SUN')
        ];
        $now = DateHelper::make();
        $nowDate = $now->format('Y-m-d');
        $time = $now->format('H:i:s');
        if (!empty($product_id)) {
            $options = GridboxHelper::$storeHelper->getProductData($product_id)->booking;
            $booking = GridboxHelper::getBooking();
        }
        include(JPATH_ROOT.'/components/com_gridbox/tmpl/layout/patterns/calendar/calendar.php');

        return $out;
    }
}