<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Uri\Uri;

class CommentsController extends FormController
{
    /**
     * @return Balbooa\Component\Gridbox\Site\Model
     */
    public function getModel($name = 'Comments', $prefix = 'Site', $config = ['ignore_request' => false])
	{
		return parent::getModel($name, $prefix, $config);
	}

    public function getCommentsUser()
    {
        $user = GridboxHelper::getCommentsUser();
        echo $user;
        exit;
    }

    public function sendCommentReport()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $model = $this->getModel();
        $model->sendReportEmail($id);
        exit();
    }

    public function getCommentsPatterns()
    {
        $object = new \stdClass();
        $input = Factory::getApplication()->input;
        $sortBy = $input->get('sort-by', 'recent', 'string');
        $id = $input->post->get('id', 0, 'string');
        $userStatus = GridboxHelper::getCommentsUserLoginHTML('comments-box');
        GridboxHelper::setCommentsModerators();
        $object->commentsCount = GridboxHelper::getCommentsCountHTML($id, 'page', $sortBy);
        $object->captcha = GridboxHelper::$website->comments_recaptcha;
        $object->comments = GridboxHelper::getComments($id);
        $object->login = $userStatus->str;
        include(JPATH_ROOT.'/components/com_gridbox/tmpl/layout/patterns/comments-box/comments-box-message-pattern.php');
        $object->commentMessage = $string;
        $object->userStatus = $userStatus->status;
        $object->commentUser = GridboxHelper::$commentUser;
        if (empty(GridboxHelper::$commentUser) || (GridboxHelper::$website->comments_recaptcha_guests == 1 &&
            !empty(GridboxHelper::$commentUser) &&
            (GridboxHelper::$commentUser->type == 'user' || GridboxHelper::$commentUser->type == 'social'))) {
            $object->captcha = '';
        }
        $json = json_encode($object);
        echo $json;exit();
    }

    public function sendCommentsEmails()
    {
        $model = $this->getModel();
        $model->sendCommentsEmails();
        exit;
    }

    public function unsubscribe()
    {
        $input = Factory::getApplication()->input;
        $key = $input->get('key', '', 'string');
        $model = $this->getModel();
        $model->unsubscribe($key);
        GridboxHelper::setcookie('gridbox-comments-unsubscribe', 'unsubscribe', time()+3600);
        header('Location: '.Uri::root());
        exit;
    }

    public function moderatorDelete()
    {
        $moderator = $this->checkModerator();
        if ($moderator) {
            $input = Factory::getApplication()->input;
            $id = $input->get('id', 0, 'int');
            $model = $this->getModel();
            $model->deleteComment($id);
        }
        exit;
    }

    public function moderatorBanUser()
    {
        $moderator = $this->checkModerator();
        if ($moderator) {
            $input = Factory::getApplication()->input;
            $id = $input->get('id', 0, 'int');
            $model = $this->getModel();
            $msg = $model->moderatorBanUser($id);
            print_r($msg);
        }
        exit;
    }

    public function moderatorApprove()
    {
        $moderator = $this->checkModerator();
        if ($moderator) {
            $input = Factory::getApplication()->input;
            $id = $input->get('id', 0, 'int');
            $model = $this->getModel();
            $model->moderatorApprove($id);
        }
        exit();
    }

    public function moderatorSpam()
    {
        $moderator = $this->checkModerator();
        if ($moderator) {
            $input = Factory::getApplication()->input;
            $id = $input->get('id', 0, 'int');
            $model = $this->getModel();
            $model->moderatorSpam($id);
        }
        exit();
    }

    public function checkModerator()
    {
        $cookie = GridboxHelper::getCommentsUser();
        $flag = false;
        if (!empty($cookie)) {
            $user = json_decode($cookie);
            if ($user->type == 'user') {
                if (GridboxHelper::$website->comments_moderator_admins == 'super_user') {
                    $moderators = [];
                    $db = Factory::getDbo();
                    $query = $db->getQuery(true)
                        ->select('u.id, u.name, g.id as level')
                        ->from('`#__users` AS u')
                        ->leftJoin('`#__user_usergroup_map` AS m ON '.$db->quoteName('u.id').' = '.$db->quoteName('m.user_id'))
                        ->leftJoin('`#__usergroups` AS g ON '.$db->quoteName('g.id').' = '.$db->quoteName('m.group_id'));
                    $db->setQuery($query);
                    $users = $db->loadObjectList();
                    foreach ($users as $value) {
                        if ($value->level == 8) {
                            $moderators[] = $value->id;
                        }
                    }
                } else {
                    $moderators = explode(',', GridboxHelper::$website->comments_moderator_admins);
                }
                $flag = in_array($user->id, $moderators);
            }
        }

        return $flag;
    }

    public function logoutUser()
    {
        $cookie = GridboxHelper::getCommentsUser();
        if (!empty($cookie)) {
            $user = json_decode($cookie);
            if ($user->type == 'user') {
                /**
                 * @var Joomla\CMS\Application\SiteApplication
                 */
                $app = Factory::getApplication();
                $app->logout();
            }
        }
        GridboxHelper::removeCommentsUser();
        exit;
    }

    public function deleteComment()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $cookie = GridboxHelper::getCommentsUser();
        $user = json_decode($cookie);
        $model = $this->getModel();
        $flag = $model->checkUserPermission($user, $id);
        if ($flag) {
            $model->deleteComment($id);
        }
        exit;
    }

    private function setUserSession($data, $type)
    {
        $data->type = $type;
        $value = json_encode($data);
        GridboxHelper::setCommentsUser($value);
        echo "{}";exit;
    }

    public function loginSocial()
    {
        $input = Factory::getApplication()->input;
        $data = new \stdClass();
        $data->name = $input->post->get('name', '', 'string');
        $data->email = $input->post->get('email', '', 'string');
        $data->avatar = $input->post->get('avatar', '', 'string');
        $data->id = $input->post->get('id', '', 'string');
        $this->setUserSession($data, 'social');
    }

    public function loginUser()
    {
        $input = Factory::getApplication()->input;
        $data = new \stdClass();
        $username = $input->post->get('username', '', 'string');
        $password = $input->post->get('password', '', 'string');
        $credentials = ['username' => $username, 'password' => $password];
        /**
         * @var Joomla\CMS\Application\SiteApplication
         */
        $app = Factory::getApplication();
        if (!$app->login($credentials)) {
            $data->msg = Text::_('LOGIN_ERROR');
            $str = json_encode($data);
            echo $str;exit();
        } else {
            $user = Factory::getUser();
            $data->name = $user->name;
            $data->email = $user->email;
            $data->avatar = '';
            $data->id = $user->id;
            $this->setUserSession($data, 'user');
        }
    }

    public function loginGuest()
    {
        $input = Factory::getApplication()->input;
        $data = new \stdClass();
        $data->name = $input->post->get('name', '', 'string');
        $data->email = $input->post->get('email', '', 'string');
        $data->avatar = '';
        $data->id = 0;
        $reg = "/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,6})+$/";
        if (!empty($data->name) && !empty($data->email) && preg_match($reg, $data->email)) {
            $this->setUserSession($data, 'guest');
        }
    }

    public function setLikes()
    {
        $model = $this->getModel();
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $action = $input->get('action', 'likes', 'string');
        $model->setLikes($id, $action);
        exit;
    }

    public function uploadAttachmentFile()
    {
        $input = Factory::getApplication()->input;
        $file = $input->files->get('file', [], 'array');
        $type = $input->post->get('type', 'file', 'string');
        $model = $this->getModel();
        $obj = $model->uploadAttachmentFile($file, $type);
        $str = json_encode($obj);
        echo $str;
        exit();
    }

    public function removeTmpAttachment()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $filename = $input->get('filename', '', 'string');
        GridboxHelper::removeTmpAttachment($id, $filename);
        exit();
    }

    public function sendCommentMesssage()
    {
        $input = Factory::getApplication()->input;
        $cookie = GridboxHelper::getCommentsUser();
        $user = json_decode($cookie);
        $JUser = Factory::getUser();
        if (!empty($JUser->id)) {
            $user->name = $JUser->name;
            $user->email = $JUser->email;
            $user->avatar = '';
            $user->id = $JUser->id;
            $user->type = 'user';
        }
        $data = new \stdClass();
        $data->id = $input->get('id', 0, 'int');
        $data->page_id = $input->get('page_id', 0, 'int');
        $data->parent = $input->get('parent', 0, 'int');
        $data->message = $input->get('message', '', 'raw');
        $data->type = $input->get('type', 'reply', 'string');
        $data->name = $user->name;
        $data->email = $user->email;
        $data->user_type = $user->type;
        $data->user_id = $user->id;
        $data->avatar = $user->avatar;
        $queue = $input->get('queue', '{}', 'string');
        $queueFiles = json_decode($queue);
        foreach ($queueFiles as $key => $file) {
            GridboxHelper::removeTmpAttachment($key, $file);
        }
        $attachments = $input->get('attachments', '{}', 'string');
        $data->files = json_decode($attachments);
        $response = new \stdClass();
        $response->message = Text::_('COMMENT_SUCCESSFULY_POSTED');
        if (!empty($data->message) || $attachments != '{}') {
            $model = $this->getModel();
            $response->message = $model->sendCommentMesssage($data);
        }
        $str = json_encode($response);
        echo $str;exit;
    }
}