<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\Filesystem\File;
use Balbooa\Component\Gridbox\Administrator\Helper\Filesystem\Folder;
use Balbooa\Component\Gridbox\Site\Helper\AssetsHelper;
use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Site\Helper\HtmlPlugins\PostNavigation;
use Balbooa\Component\Gridbox\Site\Helper\MenuHelper;
use Balbooa\Component\Gridbox\Site\Requests\EditorRequest;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;

class EditorController extends FormController
{
    public function getModel($name = 'Editor', $prefix = 'Site', $config = ['ignore_request' => false])
	{
		return parent::getModel($name, $prefix, $config);
	}

    public function setModalSettings():void
    {
        $service = $this->input->get('service', '', 'string');
        $key = $this->input->get('key', '{}', 'string');
        GridboxHelper::setModalSettings($service, $key);
        exit;
    }

    public function CKEThemeRules()
    {
        $db = Factory::getDbo();
        $id = $this->input->get('id', 0, 'int');
        $query = $db->getQuery(true)
            ->select('params')
            ->from('#__template_styles')
            ->where('id = ' .$db->quote($id));
        $db->setQuery($query);
        $str = $db->loadResult();
        $params = json_decode($str);
        $theme = $params->params;
        
        $str = 'html body {';
        foreach ($theme->colorVariables as $key => $value) {
            $str .= str_replace('@', '--', $key).': '.$value->color.';';
        }
        $str .= '}';
        GridboxHelper::prepareParentFonts($theme);
        GridboxHelper::$css->prepareMediaRules();
        $str .= GridboxHelper::$css->setMediaRules($theme, false, 'createTypography');
        print_r($str);exit;
        exit;
    }

    public function submitNewItem()
    {
        $post = $this->input->post->getArray();
        $intFields = ['id', 'app_id', 'page_id'];
        foreach ($post as $key => $value) {
            $default = isset($intFields[$key]) ? 0 : '';
            $filter = isset($intFields[$key]) ? 'int' : 'raw';
            $post[$key] = $this->input->get($key, $default, $filter);
        }
        $model = $this->getModel();
        $model->submitNewItem($post);
        print_r($post);exit;
    }

    public function renameVersionsHistory()
    {
        $id = $this->input->get('id', 0, 'int');
        $title = $this->input->get('title', '', 'string');
        $model = $this->getModel();
        $model->renameVersionsHistory($id, $title);
        exit;
    }

    public function deleteVersionsHistory()
    {
        $id = $this->input->get('id', 0, 'int');
        $page_id = $this->input->get('page_id', 0, 'int');
        $model = $this->getModel();
        $model->deleteVersionsHistory($id);
        $versions = $model->getVersionsHistory($page_id);
        $str = json_encode($versions);
        echo $str;exit();
    }

    public function getVersionsHistory()
    {
        $id = $this->input->get('id', 0, 'int');
        $model = $this->getModel();
        $versions = $model->getVersionsHistory($id);
        $str = json_encode($versions);
        echo $str;exit();
    }

    public function getCountdownTimes()
    {
        $config = Factory::getConfig();
        $end = $this->input->get('end', '', 'raw');
        $offset = $config->get('offset');
        $tz = new \DateTimeZone($offset);
        $nowDate = new \DateTime('now', $tz);
        $endDate = new \DateTime($end, $tz);        
        $obj = new \stdClass();
        $obj->start = $nowDate->getTimestamp();
        $obj->end = $endDate->getTimestamp();
        $str = json_encode($obj);
        echo $str;exit;
    }

    public function getDefaultsSeo()
    {
        $id = $this->input->get('id', 0, 'int');
        $type = $this->input->get('type', '', 'string');
        $model = $this->getModel();
        $seo = $model->getDefaultsSeo($id, $type);
        $str = json_encode($seo);
        echo $str;
        exit;
    }

    public function setDefaultsSeo()
    {
        $seo = (object)[
            'id' => $this->input->get('id', 0, 'int'),
            'item_id' => $this->input->get('item_id', 0, 'int'),
            'item_type' => $this->input->get('item_type', '', 'string'),
            'meta_title' => $this->input->get('meta_title', '', 'string'),
            'meta_description' => $this->input->get('meta_description', '', 'string'),
            'share_image' => $this->input->get('share_image', '', 'string'),
            'share_title' => $this->input->get('share_title', '', 'string'),
            'share_description' => $this->input->get('share_description', '', 'string'),
            'sitemap_include' => $this->input->get('sitemap_include', '', 'string'),
            'changefreq' => $this->input->get('changefreq', '', 'string'),
            'priority' => $this->input->get('priority', '', 'string'),
            'schema_markup' => $this->input->get('schema_markup', '', 'raw')
        ];
        $model = $this->getModel();
        $model->setDefaultsSeo($seo);
        exit;
    }

    public function getUserGroups()
    {
        $groups = GridboxHelper::getUserGroups();
        $str = json_encode($groups);
        echo $str;exit;
    }

    public function checkEventField()
    {
        $response = new \stdClass();
        $response->flag = GridboxHelper::checkEventField();
        $str = json_encode($response);
        echo $str;exit();
    }

    public function checkAppFields()
    {
        $id = $this->input->get('id', 0, 'int');
        $model = $this->getModel();
        $type = $model->checkAppFields($id);
        echo $type;exit();
    }

    public function getProductOptions()
    {
        $model = $this->getModel();
        $array = $model->getProductOptions();
        $str = json_encode($array);
        echo $str;
        exit();
    }

    public function generateNewApp()
    {
        $input = Factory::getApplication()->input;
        $name = $input->get('name', 'test', 'string');
        $path = JPATH_ROOT.'/tmp/'.$name;
        $xml = simplexml_load_file(JPATH_ROOT.'/tmp/'.$name.'.xml');
        if (Folder::exists($path)) {
            GridboxHelper::deleteFolder($path);
        }
        Folder::create($path);
        foreach ($xml->apps->app as $app) {
            $obj = json_decode($app);
            $file = 'app.html';
            File::write($path.'/'.$file, $obj->app_layout);
            $file = 'app.json';
            File::write($path.'/'.$file, $obj->app_items);
            $file = 'default.html';
            File::write($path.'/'.$file, $obj->page_layout);
            $file = 'default.json';
            File::write($path.'/'.$file, $obj->page_items);
            $file = 'fields-groups.json';
            File::write($path.'/'.$file, $obj->fields_groups);
        }
        $obj = new \stdClass();
        $obj->fields = [];
        $obj->fields_data = [];
        foreach ($xml->fields->field as $field) {
            $object = json_decode($field);
            $obj->fields[] = $object;
        }
        foreach ($xml->fields_data->field_data as $field_data) {
            $object = json_decode($field_data);
            $obj->fields_data[] = $object;
        }
        $str = json_encode($obj);
        $file = 'fields.json';
        File::write($path.'/'.$file, $str);
        echo 'created';
        exit;
    }

    public function getSubmissionForm()
    {
        $id = $this->input->post->get('id', 0, 'int');
        $order = $this->input->post->get('order', [], 'array');
        $fields = $this->input->post->get('fields', [], 'array');
        foreach ($fields as $key => $field) {
            $fields[$key] = (bool)intval($field);
        }
        $str = GridboxHelper::getSubmissionForm($id, $order, $fields);
        print_r($str);exit;
    }

    public function getAppFields()
    {
        $input = Factory::getApplication()->input;
        $id = $input->post->get('id', 0, 'int');
        $type = $input->post->get('type', '', 'string');
        $edit_type = $input->post->get('edit_type', '', 'string');
        if (($type == 'post-navigation'  || $type == 'related-posts') && $edit_type != 'post-layout') {
            $id = GridboxHelper::getAppId($id);
        }
        if ($type == 'submission-form') {
            $items = GridboxHelper::getSubmissionFields($id);
        } else {
            $items = GridboxHelper::getAppFilterFields($id);
        }
        $str = json_encode($items);
        echo $str;
        exit;
    }

    public function getItemsFilter()
    {
        $input = Factory::getApplication()->input;
        $id = $input->post->get('id', 0, 'int');
        $type = $input->post->get('type', '', 'string');
        $edit_type = $input->post->get('edit_type', '', 'string');
        if (($type == 'post-navigation'  || $type == 'related-posts') && $edit_type != 'post-layout') {
            $id = GridboxHelper::getAppId($id);
        }
        $str = GridboxHelper::getItemsFilter($id);
        echo $str;exit;
    }

    public function uploadSubmissionFile()
    {
        $input = Factory::getApplication()->input;
        $file = $input->files->get('file', [], 'array');
        $app_id = $input->post->get('app_id', 0, 'int');
        $model = $this->getModel();
        $obj = $model->uploadSubmissionFile($file, $app_id);
        $str = json_encode($obj);
        echo $str;
        exit();
    }

    public function uploadDesktopFieldFile()
    {
        $input = Factory::getApplication()->input;
        $file = $input->files->get('file', [], 'array');
        $id = $input->post->get('id', 0, 'int');
        $model = $this->getModel();
        $obj = $model->uploadDesktopFieldFile($file, $id);
        $str = json_encode($obj);
        echo $str;
        exit();
    }

    public function removeDesktopFieldFile()
    {
        $id = $this->input->post->get('id', 0, 'int');
        $model = $this->getModel();
        $model->removeDesktopFieldFile($id);
        exit();
    }

    public function checkGridboxState()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('`key`')
            ->from('#__gridbox_api')
            ->where('service = '.$db->quote('balbooa'));
        $db->setQuery($query);
        $balbooa = $db->loadResult();
        print_r($balbooa);exit();
    }

    public function checkSitemap()
    {
        if (isset(GridboxHelper::$systemApps->sitemap)) {
            GridboxHelper::checkSitemap();
        }
        exit;
    }

    public function generateSitemap()
    {
        $input = Factory::getApplication()->input;
        GridboxHelper::$website->sitemap_domain = $input->get('sitemap_domain', '', 'string');
        GridboxHelper::$website->sitemap_slash = $input->get('sitemap_slash', 0, 'int');
        GridboxHelper::createSitemap();
        exit;
    }

    public function getMapsPlaces()
    {
        $input = Factory::getApplication()->input;
        $app = $input->get('app', 0, 'int');
        $menuItem = $input->post->get('menuitem', 0, 'int');
        $pages = $input->post->get('pages', '', 'string');
        $obj = GridboxHelper::getMapsPlaces($app, $menuItem, $pages);
        $str = json_encode($obj);
        header('Content-Type: text/javascript');
        echo $str;
        exit;
    }

    public function renderEventCalendar()
    {
        $input = Factory::getApplication()->input;
        $year = $input->get('year', '0', 'string');
        $month = $input->get('month', '0', 'string');
        $app = $input->get('app', 0, 'int');
        $category = $input->get('category', '', 'string');
        $tags = $input->get('tags', '', 'string');
        $type = $input->get('type', '', 'string');
        $start = $input->get('start', 0, 'int');
        $menuItem = $input->post->get('menuitem', 0, 'int');
        $time = mktime(0, 0, 0, $month, 1, $year);
        $obj = GridboxHelper::renderEventCalendarData($time, $app, $menuItem, $start, $type, $category, $tags);
        $str = json_encode($obj);
        header('Content-Type: text/javascript');
        echo $str;
        exit;
    }

    public function renderWeather()
    {
        $key = GridboxHelper::getIntegrationKey('openweathermap');
        $input = Factory::getApplication()->input;
        $view = $input->get('view', 'page', 'string');
        $placeholder = '';
        if ($view == 'gridbox') {
            $placeholder = '<div class="empty-list"><i class="zmdi zmdi-alert-polygon"></i><p>';
            $placeholder .= Text::_('ENTER_VALID_API_KEY_LOCATION').'</p></div>';
        }
        if (empty($key)) {
            echo($placeholder);exit;
        }
        $string = $input->get('weather', '{}', 'string');
        $weather = json_decode($string);
        if (empty($weather->location)) {
            echo($placeholder);exit;
        }
        $item = new \stdClass();
        $item->weather = $weather;
        $url = GridboxHelper::getWeatherURI($weather, $key);
        $data = GridboxHelper::fetch($url);
        $weather = json_decode($data);
        if (!is_object($weather) || $weather->cod != 200) {
            echo($placeholder);exit;
        }
        $forecast = GridboxHelper::renderWetherData($item->weather, $weather);
        $str = GridboxHelper::renderWetherHTML($forecast, $item);
        echo($str);exit;
    }

    public function setAppLicense()
    {
        GridboxHelper::setAppLicense('');
        header('Content-Type: text/javascript');
        echo 'var domainResponse = true;';
        exit();
    }

    public function setAppLicenseForm()
    {
        GridboxHelper::setAppLicense('');
        header('Location: https://www.balbooa.com/user/downloads/licenses');
        exit();
    }

    public function setAppLicenseBalbooa()
    {
        GridboxHelper::setAppLicenseBalbooa('');
        header('Content-Type: text/javascript');
        echo 'success';
        exit();
    }

    public function getAppLicense()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $data = $input->get('data', '', 'string');
        GridboxHelper::setAppLicense($data);
        GridboxHelper::setAppLicenseBalbooa($data);
        exit();
    }

    public function getDefaultElementsBox()
    {
        $defaultElementsBox = GridboxHelper::getDefaultElementsBox();
        header('Content-Type: text/javascript');
        $data = 'var defaultElementsBox = '.$defaultElementsBox.';';
        echo $data;exit;
    }

    public function reloadModules()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $type = $input->get('type', '', 'string');
        $model = $this->getModel();
        $str = $model->reloadModules($id, $type);
        echo $str;
        exit;
    }

    public function contentSliderAdd()
    {
        $model = $this->getModel();
        $str = $model->contentSliderAdd();
        echo $str;
        exit;
    }

    public function deleteMenuItem()
    {
        GridboxHelper::checkUserEditLevel();
        $ids = $this->input->get('id', [], 'array');
        $parents = $this->input->get('parent_id', [], 'array');
        $gridboxMenu = new MenuHelper();
        $gridboxMenu->deleteMenuItem($ids, $parents);
        exit;
    }

    public function saveMenuItemTitle()
    {
        GridboxHelper::checkUserEditLevel();
        $obj = (object) [
            'id' => $this->input->get('id', 0, 'int'),
            'title' => $this->input->get('title', '', 'string')
        ];
        $anchor = $this->input->get('anchor', '', 'string');
        $gridboxMenu = new MenuHelper();
        $gridboxMenu->saveMenuItemTitle($obj, $anchor);
        exit;
    }

    public function sortMenuItems()
    {
        GridboxHelper::checkUserEditLevel();
        $idArray = $this->input->get('idArray', [], 'array');
        $gridboxMenu = new MenuHelper();
        $gridboxMenu->sortMenuItems($idArray);
        exit;
    }

    public function getSiteCssObjeck()
    {
        $obj = GridboxHelper::getSiteCssPaterns();
        $str = json_encode($obj);
        echo $str;exit;
    }

    public function setLibraryImage()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->setLibraryImage();
    }

    public function getPostNavigation()
    {
        $input = Factory::getApplication()->input;
        $input->set('view', 'gridbox');
        $id = $input->get('id', 0, 'int');
        $maximum = $input->get('maximum', 0, 'int');
        GridboxHelper::$editItem = null;
        $model = $this->getModel();
        $model->setEditorView();
        $str = PostNavigation::getPostNavigation($maximum, $id);
        echo $str;exit;
    }

    public function getRelatedPosts()
    {
        $input = Factory::getApplication()->input;
        $input->set('view', 'gridbox');
        $id = $input->get('id', 0, 'int');
        $app = $input->get('app', 0, 'int');
        $related = $input->get('related', '', 'string');
        $limit = $input->get('limit', 0, 'int');
        $maximum = $input->get('maximum', 0, 'int');
        $type = $input->get('type', '', 'string');
        $sorting = $input->get('sorting', 'created', 'string');
        GridboxHelper::$editItem = null;
        if ($type == 'slider') {
            GridboxHelper::$editItem = new \stdClass();
            GridboxHelper::$editItem->type = 'related-posts-slider';
        }
        $model = $this->getModel();
        $model->setEditorView();
        $str = GridboxHelper::getRelatedPosts($app, $related, $limit, $maximum, $sorting, $id);
        echo $str;exit;
    }

    public function getRecentlyViewedProducts()
    {
        $input = Factory::getApplication()->input;
        $input->set('view', 'gridbox');
        $limit = $input->get('limit', 0, 'int');
        $maximum = $input->get('maximum', 0, 'int');
        GridboxHelper::$editItem = new \stdClass();
        GridboxHelper::$editItem->type = 'recently-viewed-products';
        $model = $this->getModel();
        $model->setEditorView();
        $str = GridboxHelper::getRecentlyViewedProducts($limit, $maximum);
        echo $str;exit;
    }

    public function getRecentPosts()
    {
        $input = Factory::getApplication()->input;
        $input->set('view', 'gridbox');
        $id = $input->get('id', 0, 'int');
        $sorting = $input->get('sorting', '', 'string');
        $limit = $input->get('limit', 0, 'int');
        $maximum = $input->get('maximum', 0, 'int');
        $category = $input->get('category', '', 'string');
        $tags = $input->get('tags', '', 'string');
        $type = $input->get('type', '', 'string');
        $featured = $input->get('featured', false, 'bool');
        $pagination = $input->get('pagination', '', 'string');
        GridboxHelper::$editItem = null;
        $model = $this->getModel();
        $model->setEditorView();
        $obj = new \stdClass();
        $obj->posts = GridboxHelper::getRecentPosts($id, $sorting, $limit, $maximum, $category, $featured, 0, '', $type, $tags);
        $obj->pagination = GridboxHelper::getRecentPostsPagination($id, $limit, $category, $featured, 0, $pagination, $type, $tags);
        $str = json_encode($obj);
        echo $str;exit;
    }

    public function getRecentComments()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $sorting = $input->get('sorting', '', 'string');
        $limit = $input->get('limit', 0, 'int');
        $maximum = $input->get('maximum', 0, 'int');
        $category = $input->get('category', '', 'string');
        GridboxHelper::$editItem = null;
        $str = GridboxHelper::getRecentComments($id, $sorting, $limit, $maximum, $category);
        echo $str;exit;
    }

    public function getRecentReviews()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $sorting = $input->get('sorting', '', 'string');
        $limit = $input->get('limit', 0, 'int');
        $maximum = $input->get('maximum', 0, 'int');
        $category = $input->get('category', '', 'string');
        GridboxHelper::$editItem = null;
        $str = GridboxHelper::getRecentReviews($id, $sorting, $limit, $maximum, $category);
        echo $str;exit;
    }

    public function getRecentPostsSlider()
    {
        $input = Factory::getApplication()->input;
        $input->set('view', 'gridbox');
        $id = $input->get('id', 0, 'int');
        $sorting = $input->get('sorting', '', 'string');
        $limit = $input->get('limit', 0, 'int');
        $maximum = $input->get('maximum', 0, 'int');
        $category = $input->get('category', '', 'string');
        $tags = $input->get('tags', '', 'string');
        $type = $input->get('type', '', 'string');
        $featured = $input->get('featured', false, 'bool');
        GridboxHelper::$editItem = new \stdClass();
        GridboxHelper::$editItem->type = 'recent-posts-slider';
        $model = $this->getModel();
        $model->setEditorView();
        $str = GridboxHelper::getRecentPosts($id, $sorting, $limit, $maximum, $category, $featured, 0, '', $type, $tags);
        echo $str;exit;
    }

    public function getBlogCategories()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $maximum = $input->get('maximum', 0, 'int');
        $counter = $input->get('counter', 1, 'int');
        $sub = $input->get('sub', 1, 'int');
        $title = $input->get('title', 1, 'int');
        $img = $input->get('img', 1, 'int');
        $digital = GridboxHelper::getSubscriptionProducts();
        $items = GridboxHelper::getBlogCategories($id, 0, $counter == 1, $sub == 1, $digital);
        $str = GridboxHelper::getBlogCategoriesHtml($items, $maximum, false, $counter == 1, $title == 1, $img == 1);
        echo $str;exit;
    }

    public function getBlogTags()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $category = $input->get('category', '', 'string');
        $limit = $input->get('limit', 0, 'int');
        $sorting = $input->get('sorting', '', 'string');
        $str = GridboxHelper::getBlogTags($id, $category, $limit, $sorting);
        echo $str;exit;
    }

    public function getProductData()
    {
        $model = $this->getModel();
        $data = $model->getProductData();
        echo json_encode($data);
        exit;
    }

    public function getPageTags()
    {
        $model = $this->getModel();
        $data = $model->getTagsFolders();
        $data->page = $model->getPageTags();
        echo json_encode($data);
        exit;
    }

    public function checkProductTour()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->checkProductTour();
    }

    public function getUserAuthorisedLevels()
    {
        $user = Factory::getUser();
        $groups = $user->getAuthorisedViewLevels();
        sort($groups);
        $obj = json_encode($groups);
        echo $obj;
        exit;
    }

    public function getLibraryItems()
    {
        $model = $this->getModel();
        $obj = $model->getLibraryItems();
        $obj->global = Text::_('GLOBAL_ITEM');
        $obj->delete = Text::_('DELETE');
        $obj = json_encode($obj);
        echo $obj;
        exit;
    }

    public function getBlogPosts()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $max = $input->get('max', 0, 'int');
        $limit = $input->get('limit', 0, 'int');
        $order = $input->get('order', 'created', 'string');
        $pagination = $input->get('pagination', 'created', 'pagination');
        $model = $this->getModel();
        $model->setEditorView();
        GridboxHelper::$editItem = new \stdClass();
        GridboxHelper::$editItem->type = 'blog-posts';
        echo GridboxHelper::getBlogPosts($id, $max, $limit, 0, 0, $order, $pagination);
        exit;
    }
    
    public function getBlogPagination()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $limit = $input->get('limit', 0, 'int');
        $pagination = $input->get('pagination', 'created', 'pagination');
        echo GridboxHelper::getBlogPagination($id, 0, $limit, 0, $pagination);
        exit;
    }

    public function getItems()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $theme = $input->get('theme', 0, 'int');
        $edit_type = $input->get('edit_type', '', 'string');
        $view = $input->get('view', '', 'string');
        $pageParams = GridboxHelper::getGridboxItems($id, $theme, $edit_type, $view);
        header('Content-Type: text/javascript');
        echo 'var gridboxItems = '.$pageParams;
        exit;
    }

    public function setStarRatings()
    {
        $model = $this->getModel();
        $result = $model->setStarRatings();
        echo json_encode($result);
        exit;
    }

    public function getLibrary()
    {
        $model = $this->getModel();
        $model->getLibrary();
    }

    public function requestAddLibrary()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->requestAddLibrary();
    }

    public function addLibrary()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->addLibrary();
    }

    public function removeLibrary()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->removeLibrary();
    }

    public function gridboxSaveVersion()
    {
        $data = file_get_contents('php://input');
        $obj = json_decode($data);
        $this->executeSaveVersion($obj);
    }

    public function gridboxAjaxSaveVersion()
    {
        $input = Factory::getApplication()->input;
        $data = $input->get('obj', '', 'raw');
        $obj = json_decode($data);
        $this->executeSaveVersion($obj);
    }

    public function gridboxSave()
    {
        $data = file_get_contents('php://input');
        $obj = json_decode($data);
        $this->executeSave($obj);
    }

    public function gridboxAjaxSave()
    {
        $input = Factory::getApplication()->input;
        $data = $input->get('obj', '', 'raw');
        $obj = json_decode($data);
        $this->executeSave($obj);
    }

    public function executeSaveVersion($obj)
    {
        $model = $this->getModel();
        $model->saveVersion($obj);
        echo Text::_('GRIDBOX_SAVED');
        exit;
    }

    public function cleanupVersionsHistory()
    {
        $user = Factory::getUser();
        if ($user->authorise('core.delete', 'com_gridbox')) {
            $model = $this->getModel();
            $model->cleanupVersionsHistory();
        }
        exit;
    }

    public function executeSave($obj)
    {
        $user = Factory::getUser();
        if (!isset($obj->edit_type)) {
            $pageAssets = new AssetsHelper($obj->page->id, 'page');
            $editPage = $pageAssets->checkPermission('core.edit');
            if (!$editPage && !empty($obj->page->page_category)) {
                $editPage = $pageAssets->checkEditOwn($obj->page->page_category);
            }
            $editFlag = $editPage;
        } else if ($obj->edit_type == 'post-layout' || $obj->edit_type == 'blog') {
            $editFlag = $user->authorise('core.edit.layouts', 'com_gridbox.app.'.$obj->page->id);
        } else {
            $editFlag = $user->authorise('core.edit', 'com_gridbox');
        }
        if ($editFlag) {
            $model = $this->getModel();
            $model->gridboxSave($obj);
        } else {
            echo Text::_('JLIB_APPLICATION_ERROR_EDIT_NOT_PERMITTED');
            exit;
        }
    }

    public function duplicate()
    {
        $user = Factory::getUser();
        $id = $this->input->get('id', 0, 'int');
        if ($user->authorise('core.duplicate', 'com_gridbox')) {
            $model = $this->getModel();
            $id = $model->duplicate($id);
        }
        echo($id);exit;
    }

    public function checkMainMenu()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->checkMainMenu();
    }

    public function fetchPageBlock()
    {
        GridboxHelper::checkUserEditLevel();
        $obj = new \stdClass();
        $obj->data = $this->input->get('data', '', 'raw');
        $obj->image = $this->input->get('image', '', 'raw');
        $obj->imageData = $this->input->get('imageData', '', 'raw');
        $obj->title = $this->input->get('title', '', 'raw');
        $obj->type = $this->input->get('type', '', 'raw');
        $obj->method = $this->input->get('method', '', 'raw');
        $model = $this->getModel();
        $model->getBlocksLicense($obj);
    }

    public function getBlocksLicense()
    {
        GridboxHelper::checkUserEditLevel();
        $str = file_get_contents('php://input');
        $data = json_decode($str);
        $model = $this->getModel();
        $model->getBlocksLicense($data);
    }

    public function getPluginLicense()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->getPluginLicense();
    }

    public function setNewMenuItem()
    {
        GridboxHelper::checkUserEditLevel();
        $gridboxMenu = new MenuHelper();
        $request = new EditorRequest();
        $validated = $request->get('setNewMenuItem');
        $menu = $gridboxMenu->getMenu($validated->id);
        $menutype = $menu->menutype;
        $gridboxMenu->setMenuItem($validated, $menutype);
        exit;
    }

    public function setMenuItem()
    {
        GridboxHelper::checkUserEditLevel();
        $gridboxMenu = new MenuHelper();
        $request = new EditorRequest();
        $validated = $request->get('setMenuItem');
        $validated->type = 'component';
        if (empty($validated->edit_type)) {
            $validated->link = 'index.php?option=com_gridbox&view=page&id=' . $validated->id;
        } else if ($validated->edit_type == 'blog') {
            $validated->link = 'index.php?option=com_gridbox&view=blog&app=' . $validated->id . '&id=0';
        }
        $gridboxMenu->setMenuItem($validated, $validated->menutype);
        exit;
    }

    public function getMenu()
    {
        $gridboxMenu = new MenuHelper();
        $id = $this->input->get('id', 0, 'int');
        $menu = $gridboxMenu->getMenu($id, true);
        echo json_encode($menu);
        exit;
    }

    public function getMenuItems()
    {
        GridboxHelper::checkUserEditLevel();
        $gridboxMenu = new MenuHelper();
        $menutype = $this->input->get('menutype', '', 'string');
        $items = $gridboxMenu->getMenuItems($menutype);
        echo json_encode($items);
        exit;
    }

    public function loadModule()
    {
        header('Content-Type: text/javascript');
        echo GridboxHelper::loadModule();
        exit;
    }

    public function loadLayout()
    {
        $model = $this->getModel();
        $model->loadLayout();
    }

    public function loadPlugin()
    {
        $model = $this->getModel();
        $model->loadPlugin();
    }
}