<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\Filesystem\File;
use Balbooa\Component\Gridbox\Administrator\Helper\Filesystem\Folder;
use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;

class FontsController extends FormController
{
    public function getModel($name = 'Fonts', $prefix = 'Site', $config = ['ignore_request' => false])
	{
		return parent::getModel($name, $prefix, $config);
	}

    public function getFontString()
    {
        $model = $this->getModel();
        $fonts = $model->getGoogleFonts();
        $str = GridboxHelper::createFontString($fonts);
        echo $str;exit;
    }

    public function getFonts()
    {
        GridboxHelper::checkUserEditLevel();
        $str = GridboxHelper::getFonts();
        echo $str;exit;
    }

    public function addCustomFont()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $obj = new \stdClass();
        $input = Factory::getApplication()->input;
        $font_family = $input->get('font_family', '', 'string');
        $font = str_replace(' ', '-', $font_family);
        $input = Factory::getApplication()->input;
        $files = $input->files->get('custom-files', [], 'array');
        $name = $files['name'];
        $ext = strtolower(File::getExt($name));
        $name = str_replace('.'.$ext, '', $name);
        $name = str_replace(' ', '+', $name);
        $file = GridboxHelper::replace($name);
        $file = File::makeSafe($file.'.'.$ext);
        $name = str_replace('-', '', $file);
        $name = str_replace($ext, '', $name);
        $name = str_replace('.', '', $name);
        if ($name == '') {
            $file = date("Y-m-d-H-i-s").'.'.$ext;
        }
        $name = strtolower($file);
        $file = $font.'/'.$name;
        if ($model->addFont($file)) {
            $dir = JPATH_ROOT. '/templates/gridbox/library/fonts';
            if (!Folder::exists($dir)) {
                Folder::create($dir);
            }
            $dir .= '/'.$font;
            if (!Folder::exists($dir)) {
                Folder::create($dir);
            }
            File::upload($files['tmp_name'], $dir.'/'.$name);
            $obj->msg = Text::_('FONT_IS_ADDED');
            $obj->type = '';
        } else {
            $obj->msg = Text::_('FONT_ALREADY_INSTALLED');
            $obj->type = 'ba-alert';
        }
        echo json_encode($obj);
        exit;
    }
    
    public function addFont()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $obj = new \stdClass();
        if ($model->addFont()) {
            $obj->msg = Text::_('FONT_IS_ADDED');
            $obj->type = '';
        } else {
            $obj->msg = Text::_('FONT_ALREADY_INSTALLED');
            $obj->type = 'ba-alert';
        }
        echo json_encode($obj);
        exit;
    }
    
    public function delete()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->get('font_id', [], 'array');
        $model = $this->getModel();
        $model->delete($pks);
        echo Text::_('COM_GRIDBOX_N_ITEMS_DELETED');
        exit;
    }

    public function refreshList()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $obj = new \stdClass();
        $obj->msg = Text::_('SUCCESSFULLY_UPDATED');
        $obj->str = $model->refreshList();
        echo json_encode($obj);
        exit;
    }
}