<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\Filesystem\File;
use Balbooa\Component\Gridbox\Site\Helper\FileHelper;
use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Response\JsonResponse;
use Joomla\CMS\Uri\Uri;

class GridboxController extends FormController
{
    public function getModel($name = 'Gridbox', $prefix = 'Site', $config = ['ignore_request' => false])
	{
		return parent::getModel($name, $prefix, $config);
	}

    public function compressAdaptiveImage($ind = '')
    {
        $image = $this->input->get('image', '', 'string');
        $compressed = GridboxHelper::getCompressFolder($image, $ind);
        $dir = JPATH_ROOT.$image;
        $gd_info = gd_info();
        $imageCreate = FileHelper::imageCreate($compressed->ext);        
        $dev = $this->input->get('dev_mode', '', 'string');
        if (!$gd_info['WebP Support'] && !empty($dev)) {
            print_r('Your PHP image library GD was compiled without WebP Support');exit;
        }
        $imageSave = FileHelper::imageSave($compressed->endExt);
        $size = GridboxHelper::$website->images_max_size * 1;
        if (!empty($ind)) {
            $size = GridboxHelper::$breakpoints->{$ind} * 1;
        }
        $quality = GridboxHelper::$website->images_quality * 1;
        if (!empty($ind)) {
            $quality = GridboxHelper::$website->adaptive_quality * 1;
        }
        $exists = File::exists($compressed->path) && filesize($compressed->path) != 0;
        $origFlag = File::exists($dir);
        if (($origFlag && !$exists && !$im = $imageCreate($dir)) || !$origFlag) {
            $compressed->url = Uri::root(true).$image;
        } else if ($origFlag && !$exists) {
            $width = imagesx($im);
            $height = imagesy($im);
            if ($width <= $size && $height <= $size) {
                $w = $width;
                $h = $height;
            } else {
                $ratio = $width / $height;
                if ($width > $height) {
                    $w = $size;
                    $h = $size / $ratio;
                } else {
                    $h = $size;
                    $w = $size * $ratio;
                }
            }
            $out = imagecreatetruecolor($w, $h);
            if ($compressed->ext == 'png' || $compressed->ext == 'webp') {
                imagealphablending($out, false);
                imagesavealpha($out, true);
                $transparent = imagecolorallocatealpha($out, 255, 255, 255, 127);
                imagefilledrectangle($out, 0, 0, $w, $h, $transparent);
            }
            imagecopyresampled($out, $im, 0, 0, 0, 0, $w, $h, $width, $height);
            if ($compressed->endExt == 'png') {
                $quality = 9 - round($quality / 11.111111111111);
            }
            $imageSave($out, $compressed->path, $quality);
            imagedestroy($out);
            imagedestroy($im);
        }
        if ($origFlag) {
            header('Location: '.$compressed->url);
        }
        exit;
    }

    public function compressImagelaptop()
    {
        $this->compressAdaptiveImage('laptop');
    }

    public function compressImagetb()
    {
        $this->compressAdaptiveImage('tablet');
    }

    public function compressImagetbpt()
    {
        $this->compressAdaptiveImage('tablet-portrait');
    }

    public function compressImagesm()
    {
        $this->compressAdaptiveImage('phone');
    }

    public function compressImagesmpt()
    {
        $this->compressAdaptiveImage('phone-portrait');
    }

    public function compressImage()
    {
        self::compressAdaptiveImage();
    }

    public function login()
    {
        $input = Factory::getApplication()->input;
        $login = $input->get('ba_login', '', 'string');
        $password = $input->get('ba_password', '', 'string');
        $credentials = ['username' => $login, 'password' => $password];
        $msg = '';
        $app = Factory::getApplication();
        if (!$app->login($credentials)) {
            $msg = Text::_('LOGIN_ERROR');
        }
        echo $msg;
        exit;
    }

    public function createSystemPage()
    {
        $model = $this->getModel();
        $id = $model->createSystemPage();
        echo $id;
        exit;
    }

    public function createPage()
    {
        $model = $this->getModel();
        $id = $model->createPage();
        echo $id;
        exit;
    }

    public function getSession()
    {
        $session = Factory::getSession();
        echo new JsonResponse($session->getState());
        exit;
    }

    public function save($key = NULL, $urlVar = NULL)
    {
        
    }
}