<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\FormController;

class PageController extends FormController
{
    /**
     * @return Balbooa\Component\Gridbox\Site\Model
     */
    public function getModel($name = 'Page', $prefix = 'Site', $config = ['ignore_request' => false])
	{
		return parent::getModel($name, $prefix, $config);
	}

    public function getItemsFilterCount()
    {
        $input = Factory::getApplication()->input;
        $app = $input->get('app', 0, 'int');
        $data = $input->get('data', '', 'raw');
        $object = json_decode($data);
        $count = GridboxHelper::getItemsFilterCount($app, $object);
        print_r($count);
        exit;
    }

	public function getRecentPosts()
    {
        $input = Factory::getApplication()->input;
        $input->set('view', 'page');
        $id = $input->get('id', 0, 'int');
        $sorting = $input->get('sorting', '', 'string');
        $limit = $input->get('limit', 0, 'int');
        $maximum = $input->get('maximum', 0, 'int');
        $category = $input->get('category', '', 'string');
        $tags = $input->get('tags', '', 'string');
        $type = $input->get('type', '', 'string');
        $featured = $input->get('featured', false, 'bool');
        $pagination = $input->get('pagination', '', 'string');
        $item = $input->get('item', '{}', 'raw');
        $start = $input->get('page', 1, 'int');
        $not = $input->get('not', '', 'string');
        $start--;
        GridboxHelper::$editItem = json_decode($item);
        $obj = new \stdClass();
		$obj->pagination = GridboxHelper::getRecentPostsPagination($id, $limit, $category, $featured, $start, $pagination, $type, $tags);
        $start *= $limit;
        $obj->posts = GridboxHelper::getRecentPosts($id, $sorting, $limit, $maximum, $category, $featured, $start, $not, $type, $tags);
        $str = json_encode($obj);
        echo $str;exit;
    }
}