<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\FormController;

class PagesController extends FormController
{
    public function getModel($name = 'Pages', $prefix = 'Site', $config = ['ignore_request' => false])
	{
		return parent::getModel($name, $prefix, $config);
	}

	public function setCookie()
	{
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $key = $input->get('key', '', 'string');
		$value = $input->get('value', '', 'string');
		setcookie($key, $value, time()+7200);
		exit;
	}

	public function getGalleryCategories()
    {
        $result = [];
        if (class_exists('Balbooa\Component\Gallery\Site\Model\GalleryModel')
            && method_exists('Balbooa\Component\Gallery\Site\Model\GalleryModel', 'getCategories')) {
            $model = new \Balbooa\Component\Gallery\Site\Model\GalleryModel();
            $id = $this->input->get('gallery', 0, 'int');
            $categories = $model->getCategories($id);
            foreach ($categories as $category) {
                if ($category->category_all == 1) {
                    continue;
                }
                $result[] = $category;
            }
        } else if (class_exists('Balbooa\Component\Gallery\Site\Controller\GalleryController')) {
            $controller = new \Balbooa\Component\Gallery\Site\Controller\GalleryController([]);
            $controller->getCategories();
        }
        echo(json_encode($result));
        exit;
    }
}