<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Site\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Uri\Uri;

class ReviewsController extends FormController
{
    /**
     * @return Balbooa\Component\Gridbox\Site\Model
     */
    public function getModel($name = 'Reviews', $prefix = 'Site', $config = ['ignore_request' => false])
	{
		return parent::getModel($name, $prefix, $config);
	}

    public function sendCommentReport()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $model = $this->getModel();
        $model->sendReportEmail($id);
        exit();
    }

    public function getReviewById()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $page = $input->get('page', 0, 'int');
        $replyName = $input->get('replyName', '', 'string');
        $sortBy = $input->get('sort-by', 'recent', 'string');
        $object = new \stdClass();
        $userStatus = GridboxHelper::getCommentsUserLoginHTML('reviews');
        GridboxHelper::setReviewsModerators();
        $object->commentsCount = GridboxHelper::getReviewsCountHTML($page, 'page', $sortBy);
        $object->captcha = GridboxHelper::$website->reviews_recaptcha;
        $object->comment = GridboxHelper::getReviewById($id, $replyName);
        $object->login = $userStatus->str;
        include(JPATH_ROOT.'/components/com_gridbox/tmpl/layout/patterns/reviews/reviews-message-pattern.php');
        $object->commentMessage = $string;
        $object->userStatus = $userStatus->status;
        $object->commentUser = GridboxHelper::$commentUser;
        if (empty(GridboxHelper::$commentUser) || (GridboxHelper::$website->reviews_recaptcha_guests == 1 &&
            !empty(GridboxHelper::$commentUser) &&
            (GridboxHelper::$commentUser->type == 'user' || GridboxHelper::$commentUser->type == 'social'))) {
            $object->captcha = '';
        }
        $json = json_encode($object);
        echo $json;exit();
    }

    public function getReviewsMoreReply()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $parent = $input->get('parent', 0, 'int');
        $replyName = $input->get('replyName', '', 'string');
        $limit = $input->get('limit', 0, 'int');
        $object = new \stdClass();
        $userStatus = GridboxHelper::getCommentsUserLoginHTML('reviews');
        GridboxHelper::setReviewsModerators();
        $object->captcha = GridboxHelper::$website->reviews_recaptcha;
        $object->comments = GridboxHelper::getReviews($id, $parent, 1, $replyName, 1, $limit);
        $object->login = $userStatus->str;
        include(JPATH_ROOT.'/components/com_gridbox/tmpl/layout/patterns/reviews/reviews-message-pattern.php');
        $object->commentMessage = $string;
        $object->userStatus = $userStatus->status;
        $object->commentUser = GridboxHelper::$commentUser;
        if (empty(GridboxHelper::$commentUser) || (GridboxHelper::$website->reviews_recaptcha_guests == 1 &&
            !empty(GridboxHelper::$commentUser) &&
            (GridboxHelper::$commentUser->type == 'user' || GridboxHelper::$commentUser->type == 'social'))) {
            $object->captcha = '';
        }
        $json = json_encode($object);
        echo $json;exit();
    }

    public function getCommentsPatterns()
    {
        $object = new \stdClass();
        $input = Factory::getApplication()->input;
        $sortBy = $input->get('sort-by', 'recent', 'string');
        $id = $input->get('id', 0, 'int');
        $next = $input->get('next', 1, 'int');
        $reviewID = $input->get('reviewID', 0, 'int');
        $userStatus = GridboxHelper::getCommentsUserLoginHTML('reviews');
        GridboxHelper::setReviewsModerators();
        $object->commentsCount = GridboxHelper::getReviewsCountHTML($id, 'page', $sortBy);
        $object->captcha = GridboxHelper::$website->reviews_recaptcha;
        $object->comments = GridboxHelper::getReviews($id, 0, 0, '', $next, 2, $reviewID);
        $object->login = $userStatus->str;
        include(JPATH_ROOT.'/components/com_gridbox/tmpl/layout/patterns/reviews/reviews-message-pattern.php');
        $object->commentMessage = $string;
        $object->userStatus = $userStatus->status;
        $object->commentUser = GridboxHelper::$commentUser;
        if (empty(GridboxHelper::$commentUser) || (GridboxHelper::$website->reviews_recaptcha_guests == 1 &&
            !empty(GridboxHelper::$commentUser) &&
            (GridboxHelper::$commentUser->type == 'user' || GridboxHelper::$commentUser->type == 'social'))) {
            $object->captcha = '';
        }
        $json = json_encode($object);
        echo $json;exit();
    }

    public function sendCommentsEmails()
    {
        $model = $this->getModel();
        $model->sendCommentsEmails();
        exit;
    }

    public function unsubscribe()
    {
        $input = Factory::getApplication()->input;
        $key = $input->get('key', '', 'string');
        $model = $this->getModel();
        $model->unsubscribe($key);
        GridboxHelper::setcookie('gridbox-comments-unsubscribe', 'unsubscribe', time()+3600);
        header('Location: '.Uri::root());
        exit;
    }

    public function moderatorDelete()
    {
        $moderator = $this->checkModerator();
        if ($moderator) {
            $input = Factory::getApplication()->input;
            $id = $input->get('id', 0, 'int');
            $model = $this->getModel();
            $model->deleteComment($id);
        }
        exit;
    }

    public function moderatorBanUser()
    {
        $moderator = $this->checkModerator();
        if ($moderator) {
            $input = Factory::getApplication()->input;
            $id = $input->get('id', 0, 'int');
            $model = $this->getModel();
            $msg = $model->moderatorBanUser($id);
            print_r($msg);
        }
        exit;
    }

    public function moderatorApprove()
    {
        $moderator = $this->checkModerator();
        if ($moderator) {
            $input = Factory::getApplication()->input;
            $id = $input->get('id', 0, 'int');
            $model = $this->getModel();
            $model->moderatorApprove($id);
        }
        exit();
    }

    public function moderatorSpam()
    {
        $moderator = $this->checkModerator();
        if ($moderator) {
            $input = Factory::getApplication()->input;
            $id = $input->get('id', 0, 'int');
            $model = $this->getModel();
            $model->moderatorSpam($id);
        }
        exit();
    }

    public function checkModerator()
    {
        $cookie = GridboxHelper::getCommentsUser();
        $flag = false;
        if (!empty($cookie)) {
            $user = json_decode($cookie);
            if ($user->type == 'user') {
                if (GridboxHelper::$website->reviews_moderator_admins == 'super_user') {
                    $moderators = [];
                    $db = Factory::getDbo();
                    $query = $db->getQuery(true)
                        ->select('u.id, u.name, g.id as level')
                        ->from('`#__users` AS u')
                        ->leftJoin('`#__user_usergroup_map` AS m ON '.$db->quoteName('u.id').' = '.$db->quoteName('m.user_id'))
                        ->leftJoin('`#__usergroups` AS g ON '.$db->quoteName('g.id').' = '.$db->quoteName('m.group_id'));
                    $db->setQuery($query);
                    $users = $db->loadObjectList();
                    foreach ($users as $value) {
                        if ($value->level == 8) {
                            $moderators[] = $value->id;
                        }
                    }
                } else {
                    $moderators = explode(',', GridboxHelper::$website->reviews_moderator_admins);
                }
                $flag = in_array($user->id, $moderators);
            }
        }

        return $flag;
    }

    public function deleteComment()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $cookie = GridboxHelper::getCommentsUser();
        $user = json_decode($cookie);
        $model = $this->getModel();
        $flag = $model->checkUserPermission($user, $id);
        if ($flag) {
            $model->deleteComment($id);
        }
        exit;
    }

    public function setLikes()
    {
        $model = $this->getModel();
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $action = $input->get('action', 'likes', 'string');
        $model->setLikes($id, $action);
        exit;
    }

    public function uploadAttachmentFile()
    {
        $input = Factory::getApplication()->input;
        $file = $input->files->get('file', [], 'array');
        $type = $input->post->get('type', 'file', 'string');
        $model = $this->getModel();
        $obj = $model->uploadAttachmentFile($file, $type);
        $str = json_encode($obj);
        echo $str;
        exit();
    }

    public function removeTmpAttachment()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $filename = $input->get('filename', '', 'string');
        GridboxHelper::removeTmpReviewsAttachment($id, $filename);
        exit();
    }

    public function sendCommentMesssage()
    {
        $input = Factory::getApplication()->input;
        $cookie = GridboxHelper::getCommentsUser();
        $user = json_decode($cookie);
        $data = new \stdClass();
        $data->id = $input->get('id', 0, 'int');
        $data->page_id = $input->get('page_id', 0, 'int');
        $data->parent = $input->get('parent', 0, 'int');
        $data->rating = $input->get('rating', 0, 'int');
        $data->message = $input->get('message', '', 'raw');
        $data->type = $input->get('type', 'reply', 'string');
        $data->name = $user->name;
        $data->email = $user->email;
        $data->user_type = $user->type;
        $data->user_id = $user->id;
        $data->avatar = $user->avatar;
        $queue = $input->get('queue', '{}', 'string');
        $queueFiles = json_decode($queue);
        foreach ($queueFiles as $key => $file) {
            GridboxHelper::removeTmpReviewsAttachment($key, $file);
        }
        $attachments = $input->get('attachments', '{}', 'string');
        $data->files = json_decode($attachments);
        $model = $this->getModel();
        $response = new \stdClass();
        $response->message = $data->parent == 0 ? Text::_('REVIEW_SUCCESSFULY_POSTED') : Text::_('COMMENT_SUCCESSFULY_POSTED');
        if ($data->type == 'submit' && $model->checkUserReviews($user, $data->page_id)) {
            $response->message = Text::_('ALREADY_VOTED');
            $response->type = 'error';
        } else if (!empty($data->message) || $attachments != '{}') {
            $response->message = $model->sendCommentMesssage($data);
        }
        $str = json_encode($response);
        echo $str;exit;
    }
}