<?php
/**
 * @package   Gridbox
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Gridbox\Site\Enums\Finder;

use Balbooa\Component\Gridbox\Site\Events\Finder\PageAfterSave;
use Balbooa\Component\Gridbox\Site\Events\Finder\PagesAfterDelete;
use Balbooa\Component\Gridbox\Site\Interface\Enums\EventsInterface;
use Joomla\Event\EventInterface;

defined('_JEXEC') or die;

enum FinderEvents: string implements EventsInterface
{
    case Save = 'onPageAfterSave';
    case Delete = 'onPagesAfterDelete';

    public function make(array $data): EventInterface
    {
        return match ($this) {
            self::Save => new PageAfterSave($this->value, $data),
            self::Delete => new PagesAfterDelete($this->value, $data)
        };
    }

    public function getName(): string
    {
        return $this->value;
    }
}