<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Site\Helper\Dashboard;

use Balbooa\Component\Gridbox\Administrator\Trait\BookingQueryTrait;
use Joomla\CMS\Factory;
use Balbooa\Component\Gridbox\Site\Interface\DashboardInterface;
use Balbooa\Component\Gridbox\Site\Interface\DashboardItemsInterface;

class BookingHelper implements DashboardInterface, DashboardItemsInterface
{
    use BookingQueryTrait;

    public static function make() :static
    {
        return new static();
    }
    
    public function getItems($sorting = 'new') :array
    {
        $order = $sorting == 'new' ? 'id DESC' : 'start_date ASC';
        $db = Factory::getDbo();
        $query = $this->getBookingQuery()
            ->order($order);
        if ($sorting != 'new') {
            $date = date('Y-m-d');
            $where = 'b.start_date > '.$db->quote($date);
            $query->where($where);
        }
        $db->setQuery($query, 0, 10);
        $items = $db->loadObjectList();
        
        return $items;
    }
}